/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseHeartBeatStrategy
implements HeartBeatStrategy {
    private Resource resource;
    private List<HeartBeatListener> listeners = new ArrayList<HeartBeatListener>();
    private Map<String, String> configuration = new HashMap<String, String>();

    public AbstractBaseHeartBeatStrategy() {
    }

    public AbstractBaseHeartBeatStrategy(Resource resource) {
        this.resource = resource;
    }

    @Override
    public synchronized Resource getResource() {
        return this.resource;
    }

    @Override
    public synchronized void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public synchronized Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration.clear();
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
    }

    @Override
    public synchronized void addHeartBeatListener(HeartBeatListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeHeartBeatListener(HeartBeatListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireHeartBeatSuccessEvent(ResourceHeartBeatEvent event) {
        List<HeartBeatListener> listenerList = this.getListenerList();
        for (HeartBeatListener listener : listenerList) {
            listener.heartbeatSuccess(event);
        }
    }

    protected void fireHeartBeatFailureEvent(ResourceHeartBeatEvent event) {
        List<HeartBeatListener> listenerList = this.getListenerList();
        for (HeartBeatListener listener : listenerList) {
            listener.heartbeatFailure(event);
        }
    }

    protected synchronized List<HeartBeatListener> getListenerList() {
        return new ArrayList<HeartBeatListener>(this.listeners);
    }
}

