/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupPDAO
extends PersistenceDAO<ResourceGroup, Long>
implements ResourceGroupDAI {
    public ResourceGroupPDAO(JPAPersistenceContext jPAPersistenceContext) {
        super(ResourceGroup.class, jPAPersistenceContext);
    }

    @Override
    public List<ResourceGroup> findByResourceType(long l) {
        String string = "ResourceGroup.ByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        return this.buildResourceGroups(query.getResultList());
    }

    @Override
    public List<ResourceGroup> findByResourceTypeSystemId(String string) {
        String string2 = "ResourceGroup.ByResourceTypeSystemId";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("systemId", (Object)string);
        return this.buildResourceGroups(query.getResultList());
    }

    @Override
    public List<ResourceGroup> findByNames(Collection<String> collection) {
        String string2;
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<ResourceGroup>();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT rg.id, rg.name ");
        stringBuilder.append(this.getFromClause()).append(" rg ");
        stringBuilder.append("WHERE rg.name IN ( ");
        boolean bl = true;
        for (String string2 : collection) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append("'" + string2 + "'");
        }
        stringBuilder.append(" ) ");
        string2 = this.getEntityManager().createQuery(stringBuilder.toString());
        return this.buildResourceGroups(string2.getResultList());
    }

    @Override
    public ResourceGroup findByName(String string) {
        String string2 = "ResourceGroup.ByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (ResourceGroup)query.getSingleResult();
    }

    @Override
    public ProtectionKey findProtectionKeyByName(String string) {
        String string2 = "ResourceGroup.ProtectionKeyByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (ProtectionKey)query.getSingleResult();
    }

    @Override
    public List<String> getAllFunctionalTypesForResourceType(long l) {
        String string = "ResourceGroup.FunctionalTypeByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        return this.convertObjectListToStringList(query.getResultList(), true);
    }

    @Override
    public boolean isNameExists(String string) {
        String string2 = "ResourceGroup.CountByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        Long l = (Long)query.getSingleResult();
        return l > 0L;
    }

    @Override
    public int getCountByResourceType(long l) {
        String string = "ResourceGroup.CountByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    private List<ResourceGroup> buildResourceGroups(List<?> list) {
        ArrayList<ResourceGroup> arrayList = new ArrayList<ResourceGroup>();
        if (list != null) {
            for (Object obj : list) {
                Object[] objectArray = (Object[])obj;
                ResourceGroup resourceGroup = new ResourceGroup();
                resourceGroup.setResourceType(new ResourceType());
                int n = 0;
                while (n < objectArray.length) {
                    switch (n) {
                        case 0: {
                            resourceGroup.setId((Long)objectArray[0]);
                            break;
                        }
                        case 1: {
                            resourceGroup.setName((String)objectArray[1]);
                            break;
                        }
                        case 2: {
                            resourceGroup.setDescription((String)objectArray[2]);
                            break;
                        }
                        case 3: {
                            resourceGroup.setFunctionalType((String)objectArray[3]);
                            break;
                        }
                        case 4: {
                            resourceGroup.setInternallyAcquired((Boolean)objectArray[4]);
                            break;
                        }
                        case 5: {
                            resourceGroup.setProtectionKey((ProtectionKey)objectArray[5]);
                            break;
                        }
                        case 6: {
                            resourceGroup.getResourceType().setId((Long)objectArray[6]);
                            break;
                        }
                        case 7: {
                            resourceGroup.getResourceType().setName((String)objectArray[7]);
                        }
                    }
                    ++n;
                }
                arrayList.add(resourceGroup);
            }
        }
        return arrayList;
    }

    private List<String> convertObjectListToStringList(List<?> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Object obj : list) {
                if (bl) {
                    if (obj == null) continue;
                    arrayList.add((String)obj);
                    continue;
                }
                arrayList.add((String)obj);
            }
        }
        return arrayList;
    }
}

