/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dto;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.dto.IVersionable;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ParameterType;
import com.tandbergtv.watchpoint.studio.dto.ResourceTypeParameter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceType
implements IWatchPointDTO,
IVersionable,
IPersistable {
    private static final long serialVersionUID = -1762516537061906221L;
    private long id = -1L;
    private String systemId;
    private String name;
    private String description;
    private Date createDate;
    private ConnectionType connectionType;
    private int messageSequenceNumber = 0;
    private AdaptorType adaptorType;
    private String adaptorClassName;
    private AdaptorScope adaptorScope;
    private String messageIdentificationClassName;
    private boolean initializationRequired = false;
    private String initializationStrategyClass;
    private boolean heartbeatRequired = false;
    private String heartbeatStrategyClass;
    private ConnectionType heartbeatConnectionType;
    private Set<ResourceTypeParameter> parameters;
    private String defaultProtocol;
    private Set<Message> messages;
    private int version;
    private boolean dirty;
    private boolean outOfTheBox;

    public ResourceType() {
    }

    public ResourceType(long l) {
        this.setId(l);
    }

    public ResourceType(long l, String string, String string2, String string3, Date date, int n, boolean bl, boolean bl2) {
        this.setId(l);
        this.setName(string);
        this.setSystemId(string2);
        this.setDescription(string3);
        this.setConnectionType(this.connectionType);
        this.setCreateDate(date);
        this.setVersion(n);
        this.setDirty(bl);
        this.setOutOfTheBox(bl2);
    }

    @Override
    public Long getKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public int getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    public void setMessageSequenceNumber(int n) {
        this.messageSequenceNumber = n;
    }

    public AdaptorType getAdaptorType() {
        if (this.adaptorType == null) {
            this.adaptorType = AdaptorType.NONE;
        }
        return this.adaptorType;
    }

    public void setAdaptorType(AdaptorType adaptorType) {
        this.adaptorType = adaptorType;
    }

    public String getAdaptorClassName() {
        return this.adaptorClassName;
    }

    public void setAdaptorClassName(String string) {
        this.adaptorClassName = string;
    }

    public Set<ResourceTypeParameter> getAllParameters() {
        HashSet<ResourceTypeParameter> hashSet = new HashSet<ResourceTypeParameter>();
        if (this.parameters != null) {
            hashSet.addAll(this.parameters);
        }
        return hashSet;
    }

    public Set<ResourceTypeParameter> getParameters() {
        return this.parameters;
    }

    protected void setParameters(Set<ResourceTypeParameter> set) {
        this.parameters = set;
    }

    public AdaptorScope getAdaptorScope() {
        return this.adaptorScope;
    }

    public void setAdaptorScope(AdaptorScope adaptorScope) {
        this.adaptorScope = adaptorScope;
    }

    public String getMessageIdentificationClassName() {
        return this.messageIdentificationClassName;
    }

    public void setMessageIdentificationClassName(String string) {
        this.messageIdentificationClassName = string;
    }

    public ConnectionType getHeartbeatConnectionType() {
        return this.heartbeatConnectionType;
    }

    public void setHeartbeatConnectionType(ConnectionType connectionType) {
        this.heartbeatConnectionType = connectionType;
    }

    public String getHeartbeatStrategyClass() {
        return this.heartbeatStrategyClass;
    }

    public void setHeartbeatStrategyClass(String string) {
        this.heartbeatStrategyClass = string;
    }

    public String getInitializationStrategyClass() {
        return this.initializationStrategyClass;
    }

    public void setInitializationStrategyClass(String string) {
        this.initializationStrategyClass = string;
    }

    public boolean isHeartbeatRequired() {
        return this.heartbeatRequired;
    }

    public void setHeartbeatRequired(boolean bl) {
        this.heartbeatRequired = bl;
    }

    public boolean isInitializationRequired() {
        return this.initializationRequired;
    }

    public void setInitializationRequired(boolean bl) {
        this.initializationRequired = bl;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String string) {
        this.defaultProtocol = string;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<Message> set) {
        this.messages = set;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void addMessage(Message message) {
        message.setResourceType(this);
        if (this.messages == null) {
            this.messages = new HashSet<Message>();
        }
        this.messages.add(message);
    }

    public void removeMessage(Message message) {
        if (this.messages == null) {
            return;
        }
        this.messages.remove(message);
    }

    public boolean isOutOfTheBox() {
        return this.outOfTheBox;
    }

    public void setOutOfTheBox(boolean bl) {
        this.outOfTheBox = bl;
    }

    public Map<String, String> getAdaptorParameters() {
        return this.getParameters(ParameterType.ADAPTOR);
    }

    public void setAdaptorParameters(Map<String, String> map) {
        this.setParameters(ParameterType.ADAPTOR, map);
    }

    public void addAdaptorParameter(String string, String string2) {
        this.addParameter(ParameterType.ADAPTOR, string, string2);
    }

    public String removeAdaptorParameter(String string) {
        return this.removeParameter(ParameterType.ADAPTOR, string);
    }

    public void removeAdaptorParameters() {
        this.removeParameters(ParameterType.ADAPTOR);
    }

    public Map<String, String> getHeartbeatParameters() {
        return this.getParameters(ParameterType.HEARTBEAT);
    }

    public void setHeartbeatParameters(Map<String, String> map) {
        this.setParameters(ParameterType.HEARTBEAT, map);
    }

    public void addHeartbeatParameter(String string, String string2) {
        this.addParameter(ParameterType.HEARTBEAT, string, string2);
    }

    public String removeHearbeatParameter(String string) {
        return this.removeParameter(ParameterType.HEARTBEAT, string);
    }

    public void removeHeartbeatParameters() {
        this.removeParameters(ParameterType.HEARTBEAT);
    }

    public Map<String, String> getInitializationParameters() {
        return this.getParameters(ParameterType.INITIALIZATION);
    }

    public void setInitializationParameters(Map<String, String> map) {
        this.setParameters(ParameterType.INITIALIZATION, map);
    }

    public void addInitializationParameter(String string, String string2) {
        this.addParameter(ParameterType.INITIALIZATION, string, string2);
    }

    public void removeInitializationParameter(String string) {
        this.removeParameter(ParameterType.INITIALIZATION, string);
    }

    public void removeInitializationParameters() {
        this.removeParameters(ParameterType.INITIALIZATION);
    }

    protected Map<String, String> getParameters(ParameterType parameterType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.parameters == null) {
            return hashMap;
        }
        for (ResourceTypeParameter resourceTypeParameter : this.parameters) {
            if (resourceTypeParameter.getType() != parameterType) continue;
            hashMap.put(resourceTypeParameter.getName(), resourceTypeParameter.getValue());
        }
        return hashMap;
    }

    protected void setParameters(ParameterType parameterType, Map<String, String> map) {
        this.removeParameters(parameterType);
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            this.addParameter(parameterType, string, map.get(string));
        }
    }

    protected void removeParameters(ParameterType parameterType) {
        if (this.parameters == null) {
            return;
        }
        Iterator<ResourceTypeParameter> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ResourceTypeParameter resourceTypeParameter = iterator.next();
            if (resourceTypeParameter.getType() != parameterType) continue;
            iterator.remove();
        }
    }

    protected void addParameter(ParameterType parameterType, String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new HashSet<ResourceTypeParameter>();
        }
        if (string == null || parameterType == null || string2 == null) {
            String string3 = "ResourceType Parameter type, name and value must all be not null.";
            throw new IllegalArgumentException(string3);
        }
        for (ResourceTypeParameter resourceTypeParameter : this.parameters) {
            if (!this.isMatchingParameter(resourceTypeParameter, parameterType, string)) continue;
            resourceTypeParameter.setValue(string2);
            return;
        }
        this.parameters.add(new ResourceTypeParameter(this, parameterType, string, string2));
    }

    protected String removeParameter(ParameterType parameterType, String string) {
        String string2 = null;
        if (this.parameters == null) {
            return string2;
        }
        Iterator<ResourceTypeParameter> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ResourceTypeParameter resourceTypeParameter = iterator.next();
            if (!this.isMatchingParameter(iterator.next(), parameterType, string)) continue;
            iterator.remove();
            string2 = resourceTypeParameter.getValue();
            break;
        }
        return string2;
    }

    protected String getParameterValue(ParameterType parameterType, String string) {
        String string2 = null;
        if (this.parameters == null) {
            return string2;
        }
        for (ResourceTypeParameter resourceTypeParameter : this.parameters) {
            if (!this.isMatchingParameter(resourceTypeParameter, parameterType, string)) continue;
            string2 = resourceTypeParameter.getValue();
            break;
        }
        return string2;
    }

    private boolean isMatchingParameter(ResourceTypeParameter resourceTypeParameter, ParameterType parameterType, String string) {
        String string2 = resourceTypeParameter.getName();
        ParameterType parameterType2 = resourceTypeParameter.getType();
        return parameterType2 == parameterType && string2.equals(string);
    }

    public int hashCode() {
        if (this.id == -1L) {
            return super.hashCode();
        }
        return new Long(this.id).hashCode() * 3 + 484;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResourceType)) {
            return false;
        }
        ResourceType resourceType = (ResourceType)object;
        if (this.id == -1L && resourceType.id == -1L) {
            return super.equals(resourceType);
        }
        return this.id == resourceType.id;
    }

    @Override
    public ResourceType clone() {
        ResourceType resourceType = null;
        try {
            resourceType = (ResourceType)super.clone();
            if (this.parameters != null) {
                resourceType.parameters = new HashSet<ResourceTypeParameter>();
                for (ResourceTypeParameter iPersistable : this.parameters) {
                    resourceType.parameters.add(iPersistable.clone());
                }
            }
            if (this.messages != null) {
                resourceType.messages = new HashSet<Message>();
                for (Message message : this.messages) {
                    resourceType.addMessage(message.clone());
                }
            }
            if (this.connectionType != null) {
                resourceType.connectionType = this.connectionType.clone();
            }
            if (this.heartbeatConnectionType != null) {
                resourceType.heartbeatConnectionType = this.heartbeatConnectionType.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return resourceType;
    }

    public String toString() {
        return this.getName();
    }
}

