/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WorkflowTemplateExporter;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateFileExporter
extends WorkflowTemplateExporter {
    private static final Logger logger = Logger.getLogger(WorkflowTemplateFileExporter.class);

    @Override
    public Map<String, Object> export(WorkflowTemplateDTO workflowTemplateDTO, Map<String, Object> map) throws ExportFailureException {
        try {
            Map<String, Object> map2 = super.export(workflowTemplateDTO, map);
            XmlAdapter xmlAdapter = SemanticElementUtil.getAdapter(map2);
            Document document = xmlAdapter.getNode().getOwnerDocument();
            String string = (String)map.get("exportFilePath");
            this.writeDocumentToFile(document, string);
            return new HashMap<String, Object>();
        }
        catch (ExportFailureException exportFailureException) {
            throw exportFailureException;
        }
        catch (Exception exception) {
            String string = "Failed to export the Workflow Template to a File.";
            throw new ExportFailureException(string, exception);
        }
    }

    private void writeDocumentToFile(Document document, String string) throws ExportFailureException {
        Writer writer = null;
        try {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                File file = new File(string);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
            catch (Exception exception) {
                String string2 = "Failed to write the template document to file: " + string;
                throw new ExportFailureException(string2, exception);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    String string3 = "Failed to close file stream for file: " + string;
                    logger.warn((Object)string3, (Throwable)iOException);
                }
            }
        }
    }
}

