/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.lock.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.lock.impl.LockOperationResult;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLockStrategy
implements ILockStrategy {
    private static final Logger logger = Logger.getLogger(DefaultLockStrategy.class);

    @Override
    public ILockOperationResult tryLock(String string, ILockable iLockable, Map<String, Serializable> map, IPersistenceContext iPersistenceContext) {
        Object object;
        Serializable serializable;
        DataAccessFactory dataAccessFactory = DataAccessFactory.createFactory();
        LockFactory lockFactory = LockFactory.createFactory();
        DataAccessInterface dataAccessInterface = null;
        DataAccessInterface dataAccessInterface2 = null;
        dataAccessInterface = dataAccessFactory.createDataAccessObject(iLockable, iPersistenceContext);
        ILockable iLockable2 = dataAccessInterface.lock(iLockable.getKey());
        boolean bl = false;
        if (map != null && (serializable = map.get(LockAttributes.OVERRIDE_LOCK.toString())) instanceof Boolean) {
            bl = (Boolean)serializable;
        }
        serializable = null;
        boolean bl2 = false;
        if (iLockable2 != null) {
            serializable = iLockable2.getLock();
            boolean bl3 = bl2 = serializable == null || bl || serializable.getOwnerId().equals(string);
            if (bl2) {
                object = lockFactory.createLock(string);
                iLockable2.setLock((ILock)object);
                iLockable2 = dataAccessInterface.update(iLockable2);
                if (serializable != null) {
                    dataAccessInterface2 = dataAccessFactory.createDataAccessObject(object, iPersistenceContext);
                    dataAccessInterface2.delete(serializable.getKey());
                }
            }
        }
        object = this.getEntityDescription(iLockable2);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("Locking Entity: ").append((String)object);
            stringBuilder.append(" with Lock: ");
            stringBuilder.append(this.getLockDescription(iLockable2.getLock()));
            if (serializable != null) {
                stringBuilder.append(", overriding existing Lock: ");
                stringBuilder.append(this.getLockDescription((ILock)serializable));
            }
        } else {
            stringBuilder.append("Failed to lock Entity: ").append((String)object);
            if (iLockable2 != null) {
                stringBuilder.append(", already has Lock: ");
                stringBuilder.append(this.getLockDescription((ILock)serializable));
            } else {
                stringBuilder.append(", entity does not exist.");
            }
        }
        logger.info((Object)stringBuilder.toString());
        return new LockOperationResult(bl2, iLockable2);
    }

    @Override
    public ILockOperationResult releaseLock(String string, ILockable iLockable, IPersistenceContext iPersistenceContext) {
        boolean bl;
        DataAccessFactory dataAccessFactory = DataAccessFactory.createFactory();
        DataAccessInterface dataAccessInterface = null;
        DataAccessInterface dataAccessInterface2 = null;
        dataAccessInterface = dataAccessFactory.createDataAccessObject(iLockable, iPersistenceContext);
        ILockable iLockable2 = dataAccessInterface.lock(iLockable.getKey());
        ILock iLock = iLockable2 != null ? iLockable2.getLock() : null;
        boolean bl2 = bl = iLock != null && iLock.getOwnerId().equals(string);
        if (bl) {
            iLockable2.setLock(null);
            iLockable2 = dataAccessInterface.update(iLockable2);
            dataAccessInterface2 = dataAccessFactory.createDataAccessObject(iLock, iPersistenceContext);
            dataAccessInterface2.delete(iLock.getKey());
        }
        String string2 = this.getEntityDescription(iLockable2);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Releasing lock for Entity: ").append(string2);
            stringBuilder.append(" with Lock: ");
            stringBuilder.append(this.getLockDescription(iLock));
        } else {
            stringBuilder.append("Failed to release lock for Entity: ").append(string2);
            if (iLock != null) {
                stringBuilder.append(" with Lock: ");
                stringBuilder.append(this.getLockDescription(iLock));
                stringBuilder.append(", lock belongs to a different user.");
            } else {
                String string3 = iLockable2 != null ? ", entity is not locked." : ", entity does not exist.";
                stringBuilder.append(string3);
            }
        }
        logger.info((Object)stringBuilder.toString());
        return new LockOperationResult(bl, iLockable2);
    }

    private String getEntityDescription(IPersistable iPersistable) {
        return iPersistable != null ? String.valueOf(iPersistable.getClass().getName()) + "[" + iPersistable.getKey() + "]" : "[null]";
    }

    private String getLockDescription(ILock iLock) {
        return String.valueOf(this.getEntityDescription(iLock)) + "[userId=" + iLock.getOwnerId() + ", createDate=" + iLock.getCreateDate() + "]";
    }
}

