/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ReferenceDeletionException;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionService
extends ServiceImpl
implements INodeDefinitionService {
    private static final String NODE_DEFINITION_ID_XPATH = "//nodeDefinition/@id";
    private static final String SEND_MESSAGE_UID_XPATH = "//action/send";
    private static final String RECEIVE_MESSAGE_UID_XPATH = "//action/receive";

    @Override
    public List<NodeDefinitionDTO> getAllNodeDefinitions() {
        Class[] classArray = new Class[]{};
        return (List)super.performOperation(classArray, new Object[0]);
    }

    @Override
    public List<NodeDefinitionDTO> getNodeDefinitionsByResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)super.performOperation(classArray, l);
    }

    @Override
    public List<NodeDefinitionDTO> getSingleNodeDefinitionsByResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)super.performOperation(classArray, l);
    }

    @Override
    public NodeDefinitionDTO getNodeDefinitionForView(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (NodeDefinitionDTO)super.performOperation(classArray, l);
    }

    @Override
    public NodeDefinitionDTO getNodeDefinitionForEdit(long l, String string, boolean bl) {
        Class[] classArray = new Class[]{Long.TYPE, String.class, Boolean.TYPE};
        return (NodeDefinitionDTO)super.performOperation(classArray, l, string, bl);
    }

    @Override
    public NodeDefinitionDTO createNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, String string, boolean bl) {
        Class[] classArray = new Class[]{NodeDefinitionDTO.class, String.class, Boolean.TYPE};
        return (NodeDefinitionDTO)super.performOperation(classArray, nodeDefinitionDTO, string, bl);
    }

    @Override
    public void deleteNodeDefinition(long l, String string, boolean bl) {
        Class[] classArray = new Class[]{Long.TYPE, String.class, Boolean.TYPE};
        super.performOperation(classArray, l, string, bl);
    }

    @Override
    public NodeDefinitionDTO saveNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, String string) {
        Class[] classArray = new Class[]{NodeDefinitionDTO.class, String.class};
        return (NodeDefinitionDTO)super.performOperation(classArray, nodeDefinitionDTO, string);
    }

    @Override
    public void closeNodeDefinition(long l, String string) {
        Class[] classArray = new Class[]{Long.TYPE, String.class};
        super.performOperation(classArray, l, string);
    }

    @Override
    public boolean nameExists(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Boolean)super.performOperation(classArray, string);
    }

    @Override
    public boolean isUsedByTemplate(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (Boolean)super.performOperation(classArray, l);
    }

    @Override
    public boolean isUsedByNodeDefinition(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (Boolean)super.performOperation(classArray, l);
    }

    protected List<NodeDefinitionDTO> getAllNodeDefinitions(IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return nodeDefinitionDTODAI.findAll();
    }

    protected List<NodeDefinitionDTO> getNodeDefinitionsByResourceType(long l, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return nodeDefinitionDTODAI.findByResourceType(l);
    }

    List<NodeDefinitionDTO> getSingleNodeDefinitionsByResourceType(long l, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return nodeDefinitionDTODAI.findSingleNodeDefinitionsByResourceType(l);
    }

    protected NodeDefinitionDTO getNodeDefinitionForView(long l, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return this.lockNodeDefinition(l, nodeDefinitionDTODAI);
    }

    protected NodeDefinitionDTO getNodeDefinitionForEdit(long l, String string, boolean bl, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        NodeDefinitionDTO nodeDefinitionDTO = this.lockNodeDefinition(l, nodeDefinitionDTODAI);
        if (nodeDefinitionDTO.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_EDIT_RESTYPE_OOB_ERROR);
        }
        ILockStrategy iLockStrategy = LockFactory.createFactory().createLockStrategy();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(LockAttributes.OVERRIDE_LOCK.toString(), Boolean.valueOf(bl));
        ILockOperationResult iLockOperationResult = iLockStrategy.tryLock(string, nodeDefinitionDTO, hashMap, iPersistenceContext);
        if (!iLockOperationResult.getOperationResult()) {
            String string2 = "Failed to acquire a lock, cannot edit this node definition.";
            ILockable iLockable = iLockOperationResult.getLockableEntity();
            throw new LockFailureException(ServiceErrorCode.ND_EDIT_LOCK_ERROR, iLockable, string2);
        }
        return (NodeDefinitionDTO)iLockOperationResult.getLockableEntity();
    }

    protected NodeDefinitionDTO createNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, String string, boolean bl, IPersistenceContext iPersistenceContext) {
        nodeDefinitionDTO.setId(-1L);
        Document document = this.loadNodeDefinitionDocument(nodeDefinitionDTO);
        String string2 = nodeDefinitionDTO.getName();
        if (string2 != null) {
            nodeDefinitionDTO.setName(string2.trim());
        }
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        this.updateNodeDefinitionsUsed(nodeDefinitionDTO, document, nodeDefinitionDTODAI);
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        this.updateMessagesUsed(nodeDefinitionDTO, document, resourceTypeDAI);
        ILock iLock = bl ? LockFactory.createFactory().createLock(string) : null;
        nodeDefinitionDTO.setLock(iLock);
        this.validateNewNodeDefinition(nodeDefinitionDTO, iPersistenceContext);
        return nodeDefinitionDTODAI.create(nodeDefinitionDTO);
    }

    protected void deleteNodeDefinition(long l, String string, boolean bl, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        NodeDefinitionDTO nodeDefinitionDTO = this.lockNodeDefinition(l, nodeDefinitionDTODAI);
        if (nodeDefinitionDTO.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_DELETE_RESTYPE_OOB_ERROR);
        }
        ILock iLock = nodeDefinitionDTO.getLock();
        if (iLock != null && !iLock.getOwnerId().equals(string)) {
            String string2 = "The node definition is locked by another user, cannot delete this node definition.";
            throw new ServiceException(ServiceErrorCode.ND_DELETE_LOCKED_ERROR, string2);
        }
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        if (!bl) {
            List<WorkflowTemplateDTO> list = workflowTemplateDTODAI.findByNodeDefinitionUsage(l);
            List<NodeDefinitionDTO> list2 = nodeDefinitionDTODAI.findByParentUsage(l);
            ArrayList<IWatchPointDTO> arrayList = new ArrayList<IWatchPointDTO>();
            arrayList.addAll(list);
            arrayList.addAll(list2);
            if (!arrayList.isEmpty()) {
                throw new ReferenceDeletionException(ServiceErrorCode.ND_NODE_DEFN_REFERENCED, arrayList);
            }
        }
        nodeDefinitionDTODAI.deleteNodeDefinitionReferences(l);
        workflowTemplateDTODAI.deleteNodeDefinitionReferences(l);
        nodeDefinitionDTODAI.delete(l);
    }

    protected NodeDefinitionDTO saveNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, String string, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        NodeDefinitionDTO nodeDefinitionDTO2 = (NodeDefinitionDTO)nodeDefinitionDTODAI.lock(nodeDefinitionDTO.getId());
        if (nodeDefinitionDTO2.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_EDIT_RESTYPE_OOB_ERROR);
        }
        ILock iLock = nodeDefinitionDTO2.getLock();
        if (iLock == null || !iLock.getOwnerId().equals(string)) {
            String string2 = "The node definition is not currently locked for the user, cannot save this node definition.";
            throw new ServiceException(ServiceErrorCode.ND_SAVE_UNLOCKED_ERROR, string2);
        }
        nodeDefinitionDTO.setLock(nodeDefinitionDTO2.getLock());
        Document document = this.loadNodeDefinitionDocument(nodeDefinitionDTO);
        this.updateNodeDefinitionsUsed(nodeDefinitionDTO, document, nodeDefinitionDTODAI);
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        this.updateMessagesUsed(nodeDefinitionDTO, document, resourceTypeDAI);
        this.validateExistingNodeDefinition(nodeDefinitionDTO, nodeDefinitionDTO2, iPersistenceContext);
        nodeDefinitionDTO = nodeDefinitionDTODAI.update(nodeDefinitionDTO);
        return nodeDefinitionDTO;
    }

    protected void closeNodeDefinition(long l, String string, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTO nodeDefinitionDTO = new NodeDefinitionDTO();
        nodeDefinitionDTO.setId(l);
        ILockStrategy iLockStrategy = LockFactory.createFactory().createLockStrategy();
        iLockStrategy.releaseLock(string, nodeDefinitionDTO, iPersistenceContext);
    }

    protected boolean nameExists(String string, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return nodeDefinitionDTODAI.getCountByName(string) > 0;
    }

    protected boolean isUsedByTemplate(long l, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        return workflowTemplateDTODAI.getCountByNodeDefinitionUsage(l) > 0;
    }

    protected boolean isUsedByNodeDefinition(long l, IPersistenceContext iPersistenceContext) {
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        return nodeDefinitionDTODAI.getCountByParentUsage(l) > 0;
    }

    protected NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext iPersistenceContext) {
        Class<NodeDefinitionDTO> clazz = NodeDefinitionDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (NodeDefinitionDTODAI)dataAccessInterface;
    }

    protected ResourceTypeDAI createResourceTypeDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceType> clazz = ResourceType.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceTypeDAI)dataAccessInterface;
    }

    protected WorkflowTemplateDTODAI createTemplateDAO(IPersistenceContext iPersistenceContext) {
        Class<WorkflowTemplateDTO> clazz = WorkflowTemplateDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (WorkflowTemplateDTODAI)dataAccessInterface;
    }

    private NodeDefinitionDTO lockNodeDefinition(long l, NodeDefinitionDTODAI nodeDefinitionDTODAI) {
        return (NodeDefinitionDTO)nodeDefinitionDTODAI.lock(l);
    }

    private Document loadNodeDefinitionDocument(NodeDefinitionDTO nodeDefinitionDTO) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            StringReader stringReader = new StringReader(nodeDefinitionDTO.getXml());
            return documentBuilderFactory.newDocumentBuilder().parse(new InputSource(stringReader));
        }
        catch (Exception exception) {
            String string = "Failed to load the node definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_INVALID_XML, string, exception);
        }
    }

    private void updateNodeDefinitionsUsed(NodeDefinitionDTO nodeDefinitionDTO, Document document, NodeDefinitionDTODAI nodeDefinitionDTODAI) {
        Object object;
        HashSet<NodeDefinitionDTO> hashSet = new HashSet<NodeDefinitionDTO>();
        nodeDefinitionDTO.setChildren(hashSet);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        try {
            object = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)object.evaluate(NODE_DEFINITION_ID_XPATH, document, XPathConstants.NODESET);
            int n = nodeList != null ? nodeList.getLength() : 0;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                String string = node.getNodeValue();
                if (string != null && string.trim().length() > 0) {
                    hashSet2.add(Long.parseLong(string));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String string = "Failed to get the list of Node Definition Ids specified in the Node Definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_NODE_DEFN_UPDATE_ERROR, string, exception);
        }
        object = nodeDefinitionDTODAI.findByKeys(hashSet2);
        if (object != null) {
            hashSet.addAll((Collection<NodeDefinitionDTO>)object);
        }
    }

    private void updateMessagesUsed(NodeDefinitionDTO nodeDefinitionDTO, Document document, ResourceTypeDAI resourceTypeDAI) {
        Object object;
        HashSet<Message> hashSet = new HashSet<Message>();
        nodeDefinitionDTO.setMessages(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        try {
            object = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)object.evaluate(SEND_MESSAGE_UID_XPATH, document, XPathConstants.NODESET);
            NodeList nodeList2 = (NodeList)object.evaluate(RECEIVE_MESSAGE_UID_XPATH, document, XPathConstants.NODESET);
            this.addMessages(nodeList, hashSet2);
            this.addMessages(nodeList2, hashSet2);
        }
        catch (Exception exception) {
            String string = "Failed to get the list of Message Uids specified in the Node Definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_MESSAGE_UPDATE_ERROR, string, exception);
        }
        object = resourceTypeDAI.getMessagesByUid(hashSet2);
        if (object != null) {
            hashSet.addAll((Collection<Message>)object);
        }
    }

    private void addMessages(NodeList nodeList, Set<String> set) {
        int n = nodeList != null ? nodeList.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getTextContent().trim();
            if (string != null && string.trim().length() > 0) {
                set.add(string);
            }
            ++n2;
        }
    }

    private void validateNewNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, IPersistenceContext iPersistenceContext) {
        Object object;
        Object object2;
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        String string = nodeDefinitionDTO.getName();
        if (string == null || string.length() == 0) {
            object2 = ValidationMessageCode.NODEDEFINITION_NAME_BLANK;
            arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object2)));
        } else {
            int n = nodeDefinitionDTODAI.getCountByName(nodeDefinitionDTO.getName());
            if (n > 0) {
                object = ValidationMessageCode.NODEDEFINITION_NAME_NOT_UNIQUE;
                arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
            }
        }
        object2 = this.createResourceTypeDAO(iPersistenceContext);
        if (object2.isOutOfTheBox(nodeDefinitionDTO.getResourceType().getId())) {
            object = ValidationMessageCode.NODEDEFINITION_CANNOT_CREATE_OOBRESTYPE;
            arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if (nodeDefinitionDTO.getType() == NodeDefinitionType.SingleNode && (object = nodeDefinitionDTO.getMessages()).size() != 0) {
            if (object.size() > 1) {
                throw new ServiceException(ServiceErrorCode.ND_INVALID_XML);
            }
            Message message = (Message)object.iterator().next();
            List<NodeDefinitionDTO> list = nodeDefinitionDTODAI.findSingleNodeDefinitionsByMessage(message.getId());
            if (list != null && !list.isEmpty()) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.NODEDEFINITION_SAME_MESSAGE_USED;
                arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, validationMessageCode));
            }
        }
        if (arrayList.size() > 0) {
            object = "The node definition failed validation during creation.";
            throw new ServiceValidationException((String)object, arrayList);
        }
    }

    private void validateExistingNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO, NodeDefinitionDTO nodeDefinitionDTO2, IPersistenceContext iPersistenceContext) {
        Object object;
        Object object2;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        String string = nodeDefinitionDTO2.getName();
        if (string == null || string.length() == 0) {
            object2 = ValidationMessageCode.NODEDEFINITION_NAME_BLANK;
            arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object2)));
        }
        object2 = this.createNodeDefinitionDAO(iPersistenceContext);
        if (nodeDefinitionDTO2.getType() == NodeDefinitionType.SingleNode && (object = nodeDefinitionDTO.getMessages()).size() != 0) {
            if (object.size() > 1) {
                throw new ServiceException(ServiceErrorCode.ND_INVALID_XML);
            }
            Message message = (Message)object.iterator().next();
            List<NodeDefinitionDTO> list = object2.findSingleNodeDefinitionsByMessage(message.getId());
            if (list != null && list.size() > 1) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.NODEDEFINITION_SAME_MESSAGE_USED;
                arrayList.add(new ValidationMessage(nodeDefinitionDTO, ValidationMessageType.Error, validationMessageCode));
            }
        }
        if (arrayList.size() > 0) {
            object = "The node definition failed validation when updating.";
            throw new ServiceValidationException((String)object, arrayList);
        }
    }
}

