/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.jbpm.gd.common.editor.AbstractContentProvider;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class NodeDefinitionContentProvider
extends AbstractContentProvider {
    protected String getRootSemanticInfoElement() {
        return "<nodeDefinition>";
    }

    protected String getNotationInfoFileName(String string) {
        if ("nodedefinition.xml".equals(string)) {
            return "gpd.xml";
        }
        return super.getNotationInfoFileName(string);
    }

    protected String getSemanticInfoFileName(String string) {
        if ("gpd.xml".equals(string)) {
            return "nodedefinition.xml";
        }
        return super.getSemanticInfoFileName(string);
    }

    protected SemanticElement getEdgeSemanticElement(Node node, Element element, int n) {
        Transition[] transitionArray = ((NodeElement)node.getSemanticElement()).getTransitions();
        return n < transitionArray.length ? transitionArray[n] : null;
    }

    protected SemanticElement getNodeSemanticElement(NodeContainer nodeContainer, Element element, int n) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        return nodeElementContainer.getNodeElementByName(element.attributeValue("name"));
    }

    protected void addEdges(Node node, Element element) {
        List list = element.elements("edge");
        int n = 0;
        while (n < list.size()) {
            SemanticElement semanticElement = this.getEdgeSemanticElement(node, (Element)list.get(n), n);
            super.addEdge(node, semanticElement, (Element)list.get(n));
            ++n;
        }
    }

    protected void addNodes(NodeContainer nodeContainer, Element element) {
        List list = element.elements("node");
        int n = 0;
        while (n < list.size()) {
            SemanticElement semanticElement = this.getNodeSemanticElement(nodeContainer, (Element)list.get(n), n);
            this.addNode(nodeContainer, semanticElement, (Element)list.get(n));
            ++n;
        }
    }

    protected SemanticElement findDestination(Edge edge, Node node) {
        NodeContainer nodeContainer = node.getContainer();
        String string = ((Transition)edge.getSemanticElement()).getTo();
        while (string.length() > 3 && "../".equals(string.substring(0, 3)) && nodeContainer != null) {
            nodeContainer = ((Node)nodeContainer).getContainer();
            string = string.substring(3);
        }
        if (nodeContainer == null) {
            return null;
        }
        SemanticElement semanticElement = nodeContainer.getSemanticElement();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (semanticElement != null && stringTokenizer.hasMoreTokens()) {
            if (!(semanticElement instanceof NodeElementContainer)) {
                return null;
            }
            semanticElement = ((NodeElementContainer)semanticElement).getNodeElementByName(stringTokenizer.nextToken());
        }
        return semanticElement;
    }
}

