/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.GraphicalEditPartFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionActionRegistry;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionContentProvider;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionCreationFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionGraphPage;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionGraphicalViewer;
import com.tandbergtv.watchpoint.studio.ui.editor.WPFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.nodedefinition.NodeDefinitionExplorer;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeDefinitionEditor
extends XMLMultiPageEditorPart
implements ITabbedPropertySheetPageContributor,
IPartListener2 {
    private static final String NODEDEFINITIONIMAGE = "nodedefinitionimage.jpg";
    private NodeDefinitionActionRegistry actionRegistry;
    private EditDomain editDomain;
    private CommandStackListener commandStackListener;
    private boolean isDirty = false;
    private ISelectionListener selectionListener;
    private SelectionSynchronizer selectionSynchronizer;
    private SemanticElementFactory semanticElementFactory;
    private NotationElementFactory notationElementFactory;
    private RootContainer rootContainer;
    private NodeDefinitionGraphPage graphPage;
    private StructuredTextEditor sourcePage;
    private MenuManager sourceContextMenuManager;
    private ContentProvider contentProvider;
    private NodeDefinitionDTO nodeDefinitionDTO;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        NodeDefinitionDTO nodeDefinitionDTO;
        FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
        this.nodeDefinitionDTO = nodeDefinitionDTO = (NodeDefinitionDTO)((WPFileEditorInput)fileEditorInput).getWatchPointDTO();
        super.init(iEditorSite, (IEditorInput)fileEditorInput);
        this.initEditDomain();
        this.initCommandStackListener();
        this.initSelectionListener();
        this.initSelectionSynchronizer();
        this.getEditorSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        Utility.setWindow(iEditorSite.getWorkbenchWindow());
    }

    protected void createPages() {
        super.createPages();
        this.initSourcePage();
        this.initActionRegistry();
        this.initGraphPage();
        this.setActivePage(0);
    }

    private void addPage(int n, IEditorPart iEditorPart, String string) {
        try {
            this.addPage(n, iEditorPart, this.getEditorInput());
            this.setPageText(n, string);
        }
        catch (PartInitException partInitException) {
            Logger.logError((String)"Could not create editor page", (Throwable)partInitException);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public String getNodeDefinitionDTOName() {
        return this.nodeDefinitionDTO != null ? this.nodeDefinitionDTO.getName() : null;
    }

    public long getNodeDefinitionDTOId() {
        return this.nodeDefinitionDTO != null ? this.nodeDefinitionDTO.getId() : 0L;
    }

    private void initActionRegistry() {
        this.actionRegistry = new NodeDefinitionActionRegistry(this);
    }

    private void initEditDomain() {
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
    }

    private void initSelectionSynchronizer() {
        this.selectionSynchronizer = this.createSelectionSynchronizer();
    }

    private void initCommandStackListener() {
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject eventObject) {
                NodeDefinitionEditor.this.handleCommandStackChanged();
            }
        };
        this.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    private void initSelectionListener() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                NodeDefinitionEditor.this.getActionRegistry().updateEditPartActions();
            }
        };
        ISelectionService iSelectionService = this.getEditorSite().getWorkbenchWindow().getSelectionService();
        iSelectionService.addSelectionListener(this.selectionListener);
    }

    protected void initGraphPage() {
        this.graphPage = new NodeDefinitionGraphPage(this);
        this.addPage(0, (IEditorPart)this.graphPage, "Diagram");
        this.getContentProvider().addNotationInfo(this.getRootContainer(), this.getEditorInput());
    }

    protected void initSourcePage() {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getEditor(n2) instanceof StructuredTextEditor) {
                this.sourcePage = (StructuredTextEditor)this.getEditor(n2);
                NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement(this.sourcePage);
                nodeDefinition.setNodeType(this.nodeDefinitionDTO.getType());
                NodeDefinitionCreationFactory nodeDefinitionCreationFactory = new NodeDefinitionCreationFactory(nodeDefinition.getElementId(), this.getSemanticElementFactory(), this.getNotationElementFactory());
                this.setRootContainer((RootContainer)nodeDefinitionCreationFactory.getNewObject());
                this.getRootContainer().setSemanticElement((SemanticElement)nodeDefinition);
                nodeDefinition.addPropertyChangeListener((PropertyChangeListener)this.getRootContainer());
                this.setTransitionSources(nodeDefinition);
            }
            ++n2;
        }
        if (this.sourcePage != null) {
            this.initSourcePageContextMenu((Control)this.sourcePage.getTextViewer().getTextWidget());
        }
    }

    private void setTransitionSources(NodeDefinition nodeDefinition) {
        NodeElement[] nodeElementArray = nodeDefinition.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            Transition[] transitionArray = nodeElement.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                transition.setSource(nodeElement);
                ++n4;
            }
            ++n2;
        }
    }

    private SemanticElement getSemanticElement(StructuredTextEditor structuredTextEditor) {
        Node node = this.getDocumentElement(structuredTextEditor);
        XmlAdapterFactory xmlAdapterFactory = new XmlAdapterFactory(node.getOwnerDocument(), this.getSemanticElementFactory());
        XmlAdapter xmlAdapter = xmlAdapterFactory.adapt(node);
        SemanticElement semanticElement = this.createMainElement();
        xmlAdapter.initialize(semanticElement);
        return semanticElement;
    }

    private Node getDocumentElement(StructuredTextEditor structuredTextEditor) {
        Element element = null;
        Document document = (Document)structuredTextEditor.getAdapter(Document.class);
        if (document != null) {
            element = document.getDocumentElement();
        }
        return element;
    }

    private void initSourcePageContextMenu(Control control) {
        this.sourceContextMenuManager = new MenuManager("#PopupMenu");
        this.sourceContextMenuManager.setRemoveAllWhenShown(true);
        this.sourceContextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                NodeDefinitionEditor.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = this.sourceContextMenuManager.createContextMenu(control);
        this.getSite().registerContextMenu("org.jbpm.ui.editor.DesignerEditor.SourcePopupMenu", this.sourceContextMenuManager, this.getSite().getSelectionProvider());
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void handleCommandStackChanged() {
        this.getActionRegistry().updateStackActions();
        if (!this.isDirty() && this.getCommandStack().isDirty()) {
            this.isDirty = true;
            this.firePropertyChange(257);
        }
        this.handleNodeDefinitionChanged();
    }

    private void handleNodeDefinitionChanged() {
        if (this.nodeDefinitionDTO.getLock() == null || !this.nodeDefinitionDTO.getLock().getOwnerId().equals(Utility.getUserName())) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Node Definition locked", (String)"This node definition is open in view mode, any changes you make will be lost.");
        }
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean isDirty() {
        return this.isLockedByCurrentUser() && (this.isDirty || super.isDirty());
    }

    public NodeDefinitionActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public NodeDefinitionGraphPage getGraphPage() {
        return this.graphPage;
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public CommandStack getCommandStack() {
        return this.editDomain.getCommandStack();
    }

    public void setSelectionSynchronizer(SelectionSynchronizer selectionSynchronizer) {
        this.selectionSynchronizer = selectionSynchronizer;
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public SemanticElementFactory getSemanticElementFactory() {
        if (this.semanticElementFactory == null) {
            this.semanticElementFactory = new SemanticElementFactory(this.getContributorId());
        }
        return this.semanticElementFactory;
    }

    public NotationElementFactory getNotationElementFactory() {
        if (this.notationElementFactory == null) {
            this.notationElementFactory = new NotationElementFactory();
        }
        return this.notationElementFactory;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public NodeDefinition getNodeDefinition() {
        if (this.rootContainer == null) {
            return null;
        }
        return (NodeDefinition)this.rootContainer.getSemanticElement();
    }

    public void setRootContainer(RootContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    public ContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public NodeDefinitionGraphicalViewer getGraphicalViewer() {
        return this.getGraphPage().getDesignerModelViewer();
    }

    public OutlineViewer getOutlineViewer() {
        return this.getGraphPage().getOutlineViewer();
    }

    public Object getAdapter(Class clazz) {
        Object object = null;
        if (clazz == CommandStack.class) {
            object = this.getCommandStack();
        } else {
            if (clazz == IContentOutlinePage.class) {
                return this.getOutlineViewer();
            }
            if (clazz == IPropertySheetPage.class) {
                return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            if (clazz == GraphicalViewer.class) {
                return this.getGraphicalViewer();
            }
            object = super.getAdapter(clazz);
        }
        return object;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        this.getGraphPage().doSave(iProgressMonitor);
        boolean bl = this.getContentProvider().saveToInput(this.getEditorInput(), this.getRootContainer());
        if (bl) {
            this.getCommandStack().markSaveLocation();
            this.setDirty(false);
            this.firePropertyChange(257);
        }
        Node node = this.getDocumentElement(this.sourcePage);
        NodeDefinitionDTO nodeDefinitionDTO = Utility.createNodeDefinitionDTO(this.nodeDefinitionDTO.getId(), this.getNodeDefinition().getName(), Utility.getXMLFromDocument(node.getOwnerDocument()), TemplateResourcesUtility.getNodeDefinitionGpdXml());
        try {
            INodeDefinitionService iNodeDefinitionService = ServiceFactory.createFactory().createNodeDefinitionService();
            this.nodeDefinitionDTO = iNodeDefinitionService.saveNodeDefinition(nodeDefinitionDTO, Utility.getUserName());
        }
        catch (Exception exception) {
            this.setDirty(true);
            this.firePropertyChange(257);
            iProgressMonitor.setCanceled(true);
            if (exception instanceof ServiceValidationException) {
                ServiceValidationException serviceValidationException = (ServiceValidationException)exception;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Node Definition", (String)"The node definition is invalid, can not save.");
                Utility.updateValidationErrors(this.getSite(), serviceValidationException.getValidationMessages());
            }
            if (exception instanceof ServiceException) {
                throw new UIException(ServiceErrors.getInstance().getProperty(((ServiceException)exception).getServiceErrorCode().getCode()), exception);
            }
            throw new UIException(exception);
        }
    }

    public void dispose() {
        super.dispose();
        this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        this.getEditorSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        this.getCommandStack().removeCommandStackListener(this.commandStackListener);
    }

    public String getDefaultImageFileName() {
        return NODEDEFINITIONIMAGE;
    }

    public String getPartName() {
        if (this.getRootContainer() == null || this.getNodeDefinition().getName() == null) {
            return super.getPartName();
        }
        return this.getNodeDefinition().getName();
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new SelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new NodeDefinitionContentProvider();
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("com.tandbergtv.watchpoint.studio.nodeDefinition");
    }

    protected NodeDefinitionGraphicalViewer createGraphicalViewer() {
        return new NodeDefinitionGraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new GraphicalEditPartFactory());
            }
        };
    }

    private boolean isLockedByCurrentUser() {
        return this.nodeDefinitionDTO.getLock() != null && this.nodeDefinitionDTO.getLock().getOwnerId().equals(Utility.getUserName());
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        IViewPart iViewPart;
        IWorkbenchPage iWorkbenchPage;
        if (iWorkbenchPartReference.getPart(false) != this) {
            return;
        }
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        INodeDefinitionService iNodeDefinitionService = serviceFactory.createNodeDefinitionService();
        if (this.nodeDefinitionDTO != null) {
            long l = this.nodeDefinitionDTO.getId();
            iNodeDefinitionService.closeNodeDefinition(l, Utility.getUserName());
        }
        if ((iWorkbenchPage = this.getSite().getPage()) != null && (iViewPart = iWorkbenchPage.findView("com.tandbergtv.gd.NodeDefinitionExplorer")) != null) {
            ((NodeDefinitionExplorer)iViewPart).refresh();
        }
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }
}

