/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.jpdl.Plugin;

public class NodeDefinitionPaletteRoot
extends PaletteRoot {
    private static final String PALETTE_EXTENSION_POINT = "org.jbpm.gd.jpdl.palette";
    private NodeDefinitionEditor editor;
    private List<IConfigurationElement> categoryList = new ArrayList<IConfigurationElement>();
    private Map<String, List<?>> categoryMap = new HashMap();

    public NodeDefinitionPaletteRoot(NodeDefinitionEditor nodeDefinitionEditor) {
        this.editor = nodeDefinitionEditor;
        this.addControls();
    }

    private void addControls() {
        String string;
        this.add((PaletteEntry)this.createDefaultControls());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PALETTE_EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            string = iConfigurationElementArray[n].getAttribute("editorClass");
            if (string != null && string.equals(((Object)((Object)this.editor)).getClass().getName())) {
                this.processPaletteContribution(iConfigurationElementArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < this.categoryList.size()) {
            string = this.categoryList.get(n);
            String string2 = String.valueOf(string.getNamespaceIdentifier()) + "." + string.getAttribute("id");
            List<?> list = this.categoryMap.get(string2);
            if (list != null && !list.isEmpty()) {
                PaletteGroup paletteGroup = new PaletteGroup(string2);
                int n2 = 0;
                while (n2 < list.size()) {
                    IConfigurationElement iConfigurationElement = (IConfigurationElement)list.get(n2);
                    String string3 = iConfigurationElement.getAttribute("icon");
                    String string4 = String.valueOf(iConfigurationElement.getNamespaceIdentifier()) + "." + iConfigurationElement.getAttribute("id");
                    String string5 = iConfigurationElement.getAttribute("label");
                    boolean bl = !"false".equals(iConfigurationElement.getAttribute("node"));
                    String string6 = iConfigurationElement.getAttribute("object");
                    String string7 = iConfigurationElement.getAttribute("tooltip");
                    org.jbpm.gd.common.editor.CreationFactory creationFactory = new org.jbpm.gd.common.editor.CreationFactory(string6, this.editor.getSemanticElementFactory(), this.editor.getNotationElementFactory());
                    Object object = bl ? new CreationToolEntry(string5, string7, (CreationFactory)creationFactory, this.getIconDescriptor(string3), null) : new ConnectionCreationToolEntry(string5, string7, (CreationFactory)creationFactory, this.getIconDescriptor(string3), null);
                    object.setId(string4);
                    paletteGroup.add((PaletteEntry)object);
                    ++n2;
                }
                this.add((PaletteEntry)paletteGroup);
            }
            ++n;
        }
    }

    private ImageDescriptor getIconDescriptor(String string) {
        return ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/" + string));
    }

    private void processPaletteContribution(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("category");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            this.categoryList.add(iConfigurationElementArray[n]);
            ++n;
        }
        iConfigurationElementArray = iConfigurationElement.getChildren("entry");
        n = 0;
        while (n < iConfigurationElementArray.length) {
            List<?> list = this.categoryMap.get(iConfigurationElementArray[n].getAttribute("category"));
            if (list == null) {
                list = new ArrayList();
                this.categoryMap.put(iConfigurationElementArray[n].getAttribute("category"), list);
            }
            list.add(iConfigurationElementArray[n]);
            ++n;
        }
    }

    private PaletteGroup createDefaultControls() {
        PaletteGroup paletteGroup = new PaletteGroup("Default Tools");
        paletteGroup.setId("org.jbpm.palette.DefaultTools");
        this.addSelectionTool(paletteGroup);
        this.addMarqueeTool(paletteGroup);
        return paletteGroup;
    }

    private void addMarqueeTool(PaletteGroup paletteGroup) {
        MarqueeToolEntry marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setId("org.jbpm.ui.palette.Marquee");
        paletteGroup.add((PaletteEntry)marqueeToolEntry);
    }

    private void addSelectionTool(PaletteGroup paletteGroup) {
        SelectionToolEntry selectionToolEntry = new SelectionToolEntry();
        selectionToolEntry.setId("org.jbpm.ui.palette.Selection");
        paletteGroup.add((PaletteEntry)selectionToolEntry);
        this.setDefaultEntry((ToolEntry)selectionToolEntry);
    }
}

