/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.AdaptorPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.GeneralPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ManagementPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.MessagesPage;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ResourceTypeEditor
extends FormEditor {
    private static final Logger logger = Logger.getLogger(ResourceTypeEditor.class);
    private boolean editorModified = false;

    protected void addPages() {
        Message message;
        this.updateTitle();
        try {
            this.addPage((IFormPage)new GeneralPage(this));
            this.addPage((IFormPage)new AdaptorPage(this));
            this.addPage((IFormPage)new MessagesPage(this));
            this.addPage((IFormPage)new ManagementPage(this));
        }
        catch (PartInitException partInitException) {
            String string = "Failed to initialize Resource Type Editor.";
            logger.error((Object)string, (Throwable)partInitException);
            throw new UIException(string, partInitException);
        }
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput != null && (message = (Message)iEditorInput.getAdapter(Message.class)) != null) {
            this.setActivePage("ResourceType.MessagesPage");
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            Object object;
            Object object2;
            int n = 0;
            while (n < this.getPageCount()) {
                object2 = this.pages.get(n);
                if (object2 instanceof IFormPage) {
                    object = (IFormPage)object2;
                    object.doSave(iProgressMonitor);
                }
                ++n;
            }
            ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput)this.getEditorInput();
            object2 = (ResourceType)resourceTypeEditorInput.getAdapter(ResourceType.class);
            this.prepareResourceTypeForSave((ResourceType)object2);
            object = ServiceFactory.createFactory();
            IResourceTypeService iResourceTypeService = ((ServiceFactory)object).createResourceTypeService();
            object2 = iResourceTypeService.updateResourceType((ResourceType)object2);
            resourceTypeEditorInput.updatePersistedResourceType((ResourceType)object2);
            this.editorSaved();
        }
        catch (ServiceValidationException serviceValidationException) {
            iProgressMonitor.setCanceled(true);
            Shell shell = this.getSite().getShell();
            String string = "The Resource Type is invalid, please fix validation errors before saving.";
            MessageDialog.openError((Shell)shell, (String)this.getTitle(), (String)string);
            Utility.updateValidationErrors(this.getSite(), serviceValidationException.getValidationMessages());
        }
        catch (ServiceException serviceException) {
            iProgressMonitor.setCanceled(true);
            Utility.reportError("Failed to save the Resource Type.", serviceException);
        }
    }

    public ResourceType getResourceType() {
        int n = 0;
        while (n < this.getPageCount()) {
            Object e = this.pages.get(n);
            if (e instanceof IFormPage) {
                IFormPage iFormPage = (IFormPage)e;
                iFormPage.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            ++n;
        }
        ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput)this.getEditorInput();
        return (ResourceType)resourceTypeEditorInput.getAdapter(ResourceType.class);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof ResourceTypeEditorInput)) {
            String string = iEditorInput.getClass().getName();
            String string2 = ResourceTypeEditorInput.class.getName();
            String string3 = "Invalid Input, expecting input of type: " + string2 + ", but received input of type: " + string;
            throw new PartInitException(string3);
        }
        super.init(iEditorSite, iEditorInput);
        Utility.setWindow(iEditorSite.getWorkbenchWindow());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.editorModified || super.isDirty();
    }

    public void editorDirtyStateChanged() {
        if (!this.editorModified && this.isDirty()) {
            this.editorModified = true;
        }
        super.editorDirtyStateChanged();
    }

    private void prepareResourceTypeForSave(ResourceType resourceType) {
        AdaptorType adaptorType = resourceType.getAdaptorType();
        if (adaptorType == null) {
            adaptorType = AdaptorType.NONE;
            resourceType.setAdaptorType(adaptorType);
        }
        if (adaptorType != AdaptorType.DEFAULT) {
            resourceType.setMessageIdentificationClassName(null);
        }
        if (adaptorType != AdaptorType.CUSTOM) {
            resourceType.setAdaptorClassName(null);
            resourceType.setAdaptorScope(null);
            resourceType.setAdaptorParameters(null);
        }
        if (!resourceType.isInitializationRequired()) {
            resourceType.setInitializationStrategyClass(null);
            resourceType.setInitializationParameters(null);
        }
        if (!resourceType.isHeartbeatRequired()) {
            resourceType.setHeartbeatStrategyClass(null);
            resourceType.setHeartbeatConnectionType(null);
            resourceType.setHeartbeatParameters(null);
        }
    }

    private void editorSaved() {
        this.editorModified = false;
        this.editorDirtyStateChanged();
        int n = 0;
        while (n < this.getPageCount()) {
            IFormPage iFormPage;
            IManagedForm iManagedForm;
            Object e = this.pages.get(n);
            if (e instanceof IFormPage && (iManagedForm = (iFormPage = (IFormPage)e).getManagedForm()) != null) {
                IFormPart[] iFormPartArray = iManagedForm.getParts();
                int n2 = iFormPartArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IFormPart iFormPart = iFormPartArray[n3];
                    if (iFormPart instanceof AbstractFormPart) {
                        ((AbstractFormPart)iFormPart).markStale();
                    }
                    ++n3;
                }
            }
            ++n;
        }
        this.updateTitle();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    private void updateTitle() {
        IEditorInput iEditorInput = this.getEditorInput();
        this.setPartName(iEditorInput.getName());
        this.setTitleToolTip(iEditorInput.getToolTipText());
    }
}

