/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IInputChangedListener;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IWatchPointEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEvent;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEventManager;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class ResourceTypeEditorInput
implements IWatchPointEditorInput,
IEditableElement {
    private ResourceType resourceType;
    private ResourceType persistedResourceType;
    private Message message;
    private boolean isEditable = true;
    private InputChangedEventManager eventManager = new InputChangedEventManager();

    public ResourceTypeEditorInput(ResourceType resourceType) {
        this(resourceType, null, true);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, boolean bl) {
        this(resourceType, null, bl);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, Message message) {
        this(resourceType, message, true);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, Message message, boolean bl) {
        this.setPersistedResourceType(resourceType);
        this.message = message;
        this.isEditable = bl;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        String string = this.resourceType.getName();
        string = String.valueOf(string) + " [" + this.resourceType.getSystemId() + "]";
        if (!this.isEditable) {
            string = String.valueOf(string) + " (Read Only)";
        }
        return string;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class clazz) {
        Object object = null;
        if (clazz.isInstance(this.resourceType)) {
            object = this.resourceType;
        } else if (clazz.isInstance(this.message)) {
            object = this.message;
        } else {
            if (clazz.isInstance(this)) {
                return this;
            }
            object = Platform.getAdapterManager().getAdapter((Object)this, clazz);
        }
        return object;
    }

    public boolean canEdit() {
        return this.isEditable;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Message getMessage() {
        return this.message;
    }

    public ResourceType getPersistedResourceType() {
        return this.persistedResourceType;
    }

    private void setPersistedResourceType(ResourceType resourceType) {
        this.persistedResourceType = resourceType;
        this.resourceType = resourceType.clone();
    }

    public void updatePersistedResourceType(ResourceType resourceType) {
        if (!this.persistedResourceType.equals(resourceType)) {
            String string = "The updated Resource Type must have the same key as the current Resource Type in the input.";
            throw new IllegalArgumentException(string);
        }
        this.persistedResourceType = resourceType;
        this.resourceType = resourceType.clone();
        InputChangedEvent inputChangedEvent = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(inputChangedEvent);
    }

    public void addCreatedMessage(Message message) {
        this.persistedResourceType.addMessage(message);
        Message message2 = message.clone();
        this.resourceType.addMessage(message2);
        InputChangedEvent inputChangedEvent = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(inputChangedEvent);
    }

    public void removeDeletedMessage(Message message) {
        this.persistedResourceType.removeMessage(message);
        this.resourceType.removeMessage(message);
        InputChangedEvent inputChangedEvent = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(inputChangedEvent);
    }

    public void addInputChangedListener(IInputChangedListener iInputChangedListener) {
        this.eventManager.addInputChangedListener(iInputChangedListener);
    }

    public void removeInputChangedListener(IInputChangedListener iInputChangedListener) {
        this.eventManager.removeInputChangedListener(iInputChangedListener);
    }

    public int hashCode() {
        if (this.resourceType == null) {
            return super.hashCode();
        }
        int n = 3 * this.resourceType.hashCode() - 421;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResourceTypeEditorInput)) {
            return false;
        }
        ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput)object;
        if (this.resourceType != null) {
            return this.resourceType.equals(resourceTypeEditorInput.resourceType);
        }
        return super.equals(object);
    }
}

