/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResourceTypeParameterDialog
extends StatusDialog {
    protected Composite formComposite;
    protected Label nameLabel;
    protected Label valueLabel;
    protected Text nameText;
    protected Text valueText;
    protected IInputValidator nameValidator;
    protected IInputValidator valueValidator;
    protected String pluginId;
    protected boolean isValidating = true;
    private String inputParameterName = null;
    private String inputParameterValue = null;
    private String outputParameterName = null;
    private String outputParameterValue = null;
    private String nameErrorMessage = null;
    private String valueErrorMessage = null;

    public ResourceTypeParameterDialog(Shell shell, String string) {
        this(shell, string, null, null);
    }

    public ResourceTypeParameterDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.setTitle("Resource Type Parameter Editor");
        this.pluginId = string;
        this.inputParameterName = string2;
        this.inputParameterValue = string3;
    }

    public void setParameterNameValidator(IInputValidator iInputValidator) {
        this.nameValidator = iInputValidator;
    }

    public void setParameterValueValidator(IInputValidator iInputValidator) {
        this.valueValidator = iInputValidator;
    }

    public String getParameterName() {
        return this.outputParameterName;
    }

    public String getParameterValue() {
        return this.outputParameterValue;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createDialogControls(composite2);
        this.initializeDialogLayouts(composite2);
        this.populateInitialData();
        return composite2;
    }

    protected void okPressed() {
        this.validateParameterName();
        this.validateParameterData();
        IStatus iStatus = this.getStatus();
        if (iStatus != null && !iStatus.matches(4)) {
            this.outputParameterName = this.nameText.getText().trim();
            this.outputParameterValue = this.valueText.getText();
            super.okPressed();
        }
    }

    protected void createDialogControls(Composite composite) {
        this.formComposite = new Composite(composite, 0);
        int n = Window.getDefaultOrientation();
        this.nameLabel = new Label(this.formComposite, n);
        this.nameLabel.setText("Name: ");
        this.nameText = new Text(this.formComposite, 0x804 | n);
        this.nameText.setTextLimit(50);
        this.nameText.addFocusListener((FocusListener)new ValidatingFocusListener());
        this.nameText.addModifyListener((ModifyListener)new ValidatingModifyListener());
        this.valueLabel = new Label(this.formComposite, n);
        this.valueLabel.setText("Value: ");
        this.valueText = new Text(this.formComposite, 0xB02 | n);
        this.valueText.setTextLimit(256);
        this.valueText.addFocusListener((FocusListener)new ValidatingFocusListener());
        this.valueText.addModifyListener((ModifyListener)new ValidatingModifyListener());
    }

    protected void initializeDialogLayouts(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginRight = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginBottom = 2;
        gridLayout.marginTop = 2;
        gridLayout.verticalSpacing = 10;
        this.formComposite.setLayout((Layout)gridLayout);
        this.nameLabel.setLayoutData((Object)this.createGridData());
        GridData gridData = this.createGridData();
        gridData.widthHint = 220 + this.valueText.getVerticalBar().getSize().x;
        this.nameText.setLayoutData((Object)gridData);
        this.valueLabel.setLayoutData((Object)this.createGridData());
        gridData = this.createGridData();
        gridData.widthHint = 220;
        gridData.heightHint = 60;
        this.valueText.setLayoutData((Object)gridData);
    }

    protected void populateInitialData() {
        this.isValidating = false;
        String string = this.inputParameterName != null ? this.inputParameterName.trim() : "";
        String string2 = this.inputParameterValue != null ? this.inputParameterValue : "";
        this.nameText.setText(string);
        this.valueText.setText(string2);
        this.nameErrorMessage = null;
        this.valueErrorMessage = null;
        this.updateStatus();
        this.isValidating = true;
    }

    private GridData createGridData() {
        return new GridData(1, 1, false, false);
    }

    private void validateParameterData() {
        if (!this.isValidating) {
            return;
        }
        String string = this.nameText.getText().trim();
        this.nameErrorMessage = this.validateData(this.nameValidator, string);
        this.valueErrorMessage = this.validateData(this.valueValidator, this.valueText.getText());
        this.updateStatus();
    }

    private void validateParameterName() {
        if (!this.isValidating) {
            return;
        }
        String string = this.nameText.getText().trim();
        this.nameErrorMessage = this.validateData(this.nameValidator, string);
        this.updateStatus();
    }

    private void validateParameterValue() {
        if (!this.isValidating) {
            return;
        }
        String string = this.valueText.getText();
        this.valueErrorMessage = this.validateData(this.valueValidator, string);
        this.updateStatus();
    }

    private String validateData(IInputValidator iInputValidator, String string) {
        String string2 = null;
        if (iInputValidator != null) {
            string2 = iInputValidator.isValid(string);
        }
        return string2;
    }

    private void updateStatus() {
        IStatus iStatus = Status.OK_STATUS;
        if (this.nameErrorMessage != null) {
            iStatus = new Status(4, this.pluginId, this.nameErrorMessage);
        } else if (this.valueErrorMessage != null) {
            iStatus = new Status(4, this.pluginId, this.valueErrorMessage);
        }
        this.updateStatus(iStatus);
    }

    private class ValidatingFocusListener
    extends FocusAdapter {
        private ValidatingFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == ResourceTypeParameterDialog.this.nameText) {
                String string = ResourceTypeParameterDialog.this.nameText.getText();
                if (!string.trim().equals(string)) {
                    ResourceTypeParameterDialog.this.nameText.setText(string.trim());
                }
                ResourceTypeParameterDialog.this.validateParameterName();
            } else if (focusEvent.getSource() == ResourceTypeParameterDialog.this.valueText) {
                ResourceTypeParameterDialog.this.validateParameterValue();
            }
        }
    }

    private class ValidatingModifyListener
    implements ModifyListener {
        private ValidatingModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (modifyEvent.getSource() == ResourceTypeParameterDialog.this.nameText) {
                ResourceTypeParameterDialog.this.validateParameterName();
            } else if (modifyEvent.getSource() == ResourceTypeParameterDialog.this.valueText) {
                ResourceTypeParameterDialog.this.validateParameterValue();
            }
        }
    }
}

