/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.AdaptorTypeSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.CustomAdaptorSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.DefaultAdaptorSectionPart;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AdaptorPage
extends ResourceTypeFormPage {
    private static final String PAGE_TITLE = "Adaptor";
    private static final String PAGE_HEADER = "Adaptor Configuration";
    public static final String PAGE_ID = "ResourceType.AdaptorPage";
    AdaptorTypeSectionPart typePart;
    DefaultAdaptorSectionPart defaultPart;
    CustomAdaptorSectionPart customPart;
    Composite configComposite;
    StackLayout configLayout;

    public AdaptorPage(ResourceTypeEditor resourceTypeEditor) {
        super(resourceTypeEditor, PAGE_ID, PAGE_TITLE);
    }

    protected void createPageControls() {
        IManagedForm iManagedForm = this.getManagedForm();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText(PAGE_HEADER);
        Composite composite = scrolledForm.getBody();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        int n = AdaptorPage.getDefaultSectionStyle();
        this.typePart = new AdaptorTypeSectionPart((IEditorPart)this, composite, formToolkit, n);
        this.typePart.getSection().setText("Adaptor Type");
        iManagedForm.addPart((IFormPart)this.typePart);
        this.configComposite = formToolkit.createComposite(composite);
        formToolkit.paintBordersFor(this.configComposite);
        this.defaultPart = new DefaultAdaptorSectionPart((IEditorPart)this, this.configComposite, formToolkit, n);
        this.defaultPart.getSection().setText("Default Adaptor Configuration");
        iManagedForm.addPart((IFormPart)this.defaultPart);
        this.customPart = new CustomAdaptorSectionPart((IEditorPart)this, this.configComposite, formToolkit, n);
        this.customPart.getSection().setText("Custom Adaptor Configuration");
        iManagedForm.addPart((IFormPart)this.customPart);
        this.typePart.getTypeCombo().addSelectionListener((SelectionListener)new TypeSelectionListener());
    }

    protected void initializePageLayout() {
        Composite composite = this.getManagedForm().getForm().getBody();
        composite.setLayout((Layout)this.createGridLayout(1, false));
        this.typePart.getSection().setLayoutData((Object)this.createSectionGridData());
        this.configComposite.setLayoutData((Object)this.createSectionGridData());
        this.configLayout = new StackLayout();
        this.configLayout.topControl = null;
        this.configComposite.setLayout((Layout)this.configLayout);
    }

    protected void populatePageData() {
        super.populatePageData();
        this.handleTypeSelection();
    }

    private void handleTypeSelection() {
        AdaptorType adaptorType = this.typePart.getAdaptorType();
        if (adaptorType == null) {
            adaptorType = AdaptorType.NONE;
        }
        Section section = null;
        switch (adaptorType) {
            case DEFAULT: {
                section = this.defaultPart.getSection();
                break;
            }
            case CUSTOM: {
                section = this.customPart.getSection();
            }
        }
        if (this.configLayout.topControl != section) {
            this.configLayout.topControl = section;
            this.configComposite.layout();
        }
    }

    class TypeSelectionListener
    implements SelectionListener {
        TypeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            AdaptorPage.this.handleTypeSelection();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            AdaptorPage.this.handleTypeSelection();
        }
    }
}

