/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DefaultAdaptorSectionPart
extends ResourceTypeSectionPart {
    Label messageIdentifierLabel;
    Label defaultMessageLabel;
    Text messageIdentifierText;

    public DefaultAdaptorSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    public void commit(boolean bl) {
        super.commit(bl);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String string = this.messageIdentifierText.getText();
            resourceType.setMessageIdentificationClassName(string);
        }
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        String string = "Message Identifier Class: ";
        this.messageIdentifierLabel = formToolkit.createLabel(this.sectionClient, string);
        this.messageIdentifierText = formToolkit.createText(this.sectionClient, "");
        this.messageIdentifierText.setTextLimit(256);
        this.messageIdentifierText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.messageIdentifierText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        formToolkit.createLabel(this.sectionClient, "");
        string = "* Leave blank in order to use default Message Identifier implementation.";
        this.defaultMessageLabel = formToolkit.createLabel(this.sectionClient, string, 64);
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.messageIdentifierLabel.setLayoutData((Object)this.createLabelGridData());
        this.defaultMessageLabel.setLayoutData((Object)this.createLabelGridData());
        GridData gridData = this.createGridData();
        gridData.widthHint = this.getDefaultClassNameTextWidth();
        this.messageIdentifierText.setLayoutData((Object)gridData);
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String string = resourceType.getMessageIdentificationClassName();
            this.messageIdentifierText.setText(this.formatValue(string, true));
        } else {
            this.messageIdentifierText.setText("");
        }
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.messageIdentifierText.setEditable(bl);
    }
}

