/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HeartbeatSectionPart
extends ResourceTypeSectionPart {
    Label classLabel;
    Label connectionTypeLabel;
    Label parametersLabel;
    Button requiredButton;
    Group configGroup;
    Text classText;
    CCombo connectionTypeCombo;
    Composite parametersComposite;
    ParametersCompositeContainer parametersContainer;
    private List<ConnectionType> connectionTypes = new ArrayList<ConnectionType>();

    public HeartbeatSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    public void commit(boolean bl) {
        super.commit(bl);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            resourceType.setHeartbeatRequired(this.requiredButton.getSelection());
            resourceType.setHeartbeatStrategyClass(this.classText.getText());
            int n = this.connectionTypeCombo.getSelectionIndex();
            ConnectionType connectionType = n != -1 ? this.connectionTypes.get(n) : null;
            resourceType.setHeartbeatConnectionType(connectionType);
            Map<String, String> map = this.parametersContainer.getParameters();
            resourceType.setHeartbeatParameters(map);
        }
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.requiredButton = formToolkit.createButton(this.sectionClient, "Requires Heartbeats", 16416);
        this.requiredButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.configGroup = new Group(this.sectionClient, 0);
        formToolkit.adapt((Composite)this.configGroup);
        formToolkit.paintBordersFor((Composite)this.configGroup);
        this.classLabel = formToolkit.createLabel((Composite)this.configGroup, "Heartbeat Strategy Class: ");
        this.classText = formToolkit.createText((Composite)this.configGroup, "");
        this.classText.setTextLimit(256);
        this.classText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.connectionTypeLabel = formToolkit.createLabel((Composite)this.configGroup, "Heartbeat Connection Type: ");
        int n = 8 | formToolkit.getBorderStyle();
        this.connectionTypeCombo = new CCombo((Composite)this.configGroup, n);
        formToolkit.adapt((Control)this.connectionTypeCombo, true, true);
        this.connectionTypeCombo.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = formToolkit.createLabel((Composite)this.configGroup, "Heartbeat Parameters: ");
        this.parametersComposite = formToolkit.createComposite((Composite)this.configGroup);
        formToolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, formToolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(1, false));
        this.requiredButton.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayout((Layout)this.createGridLayout(2, false));
        this.classLabel.setLayoutData((Object)this.createLabelGridData());
        this.connectionTypeLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        this.connectionTypeCombo.setLayoutData((Object)this.createGridData());
        GridData gridData = this.createGridData();
        gridData.widthHint = this.getDefaultClassNameTextWidth();
        this.classText.setLayoutData((Object)gridData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean bl = this.isInputEditable();
        List<ConnectionType> list = this.getAvailableConnectionTypes();
        if (list != null) {
            this.connectionTypes.clear();
            this.connectionTypes.addAll(list);
            this.connectionTypeCombo.removeAll();
            for (ConnectionType object : this.connectionTypes) {
                this.connectionTypeCombo.add(object.getName());
            }
        }
        if (resourceType != null) {
            this.requiredButton.setSelection(resourceType.isHeartbeatRequired());
            String string = resourceType.getHeartbeatStrategyClass();
            this.classText.setText(this.formatValue(string, true));
            ConnectionType connectionType = resourceType.getHeartbeatConnectionType();
            String string2 = connectionType != null ? connectionType.getName() : null;
            this.connectionTypeCombo.setText(this.formatValue(string2, false));
            Map<String, String> map = resourceType.getHeartbeatParameters();
            this.parametersContainer.setInput(map, bl);
        } else {
            this.requiredButton.setSelection(false);
            this.classText.setText("");
            this.connectionTypeCombo.setText("");
            this.parametersContainer.setInput(null, bl);
        }
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.requiredButton.setEnabled(bl);
        this.classText.setEditable(bl);
        this.connectionTypeCombo.setEnabled(bl);
        this.updateConfigControlAccess();
    }

    private void updateConfigControlAccess() {
        boolean bl = this.requiredButton.getSelection();
        this.configGroup.setEnabled(bl);
        this.classText.setEnabled(bl);
        this.connectionTypeCombo.setEnabled(this.isInputEditable() && bl);
        this.parametersContainer.setEnabled(bl);
    }

    private void handleRequiredButtonSelected() {
        if (!this.isInputEditable()) {
            return;
        }
        this.updateConfigControlAccess();
        this.configGroup.redraw();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            HeartbeatSectionPart.this.handleRequiredButtonSelected();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HeartbeatSectionPart.this.handleRequiredButtonSelected();
            if (!HeartbeatSectionPart.this.isDirty()) {
                HeartbeatSectionPart.this.markDirty();
            }
        }
    }
}

