/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.MessageInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.MessageWizard;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MessageMasterSectionPart
extends ResourceTypeSectionPart {
    private static final int MESSAGE_UID_INDEX = 0;
    private static final int MESSAGE_NAME_INDEX = 1;
    TableViewer messagesTableViewer;
    Table messagesTable;
    TableColumn nameColumn;
    TableColumn uidColumn;
    Composite buttonComposite;
    Button createButton;
    Button deleteButton;
    Label createInfoLabel;
    Label infoLabel;

    public MessageMasterSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.initializeMessagesTable(iManagedForm);
        this.buttonComposite = formToolkit.createComposite(this.sectionClient);
        formToolkit.paintBordersFor(this.buttonComposite);
        this.createButton = formToolkit.createButton(this.buttonComposite, "Create...", 8);
        this.deleteButton = formToolkit.createButton(this.buttonComposite, "Delete", 8);
        this.createButton.addSelectionListener((SelectionListener)new ButtonPressListener());
        this.deleteButton.addSelectionListener((SelectionListener)new ButtonPressListener());
        String string = "* Messages cannot be created if no Adaptor Configuration is saved.";
        this.createInfoLabel = formToolkit.createLabel(this.sectionClient, string, 64);
        String string2 = "* Messages that are created or deleted are instantly saved, and do not require saving the Resource Type.";
        this.infoLabel = formToolkit.createLabel(this.sectionClient, string2, 64);
    }

    private void initializeMessagesTable(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        int n = 66308;
        this.messagesTable = formToolkit.createTable(this.sectionClient, n);
        formToolkit.paintBordersFor((Composite)this.messagesTable);
        this.uidColumn = new TableColumn(this.messagesTable, 16384, 0);
        this.uidColumn.setText("Message UID");
        this.uidColumn.setToolTipText("Message UID");
        this.uidColumn.setResizable(true);
        this.uidColumn.setMoveable(false);
        this.uidColumn.setWidth(110);
        this.nameColumn = new TableColumn(this.messagesTable, 16384, 1);
        this.nameColumn.setText("Message Name");
        this.nameColumn.setToolTipText("Message Name");
        this.nameColumn.setResizable(true);
        this.nameColumn.setMoveable(false);
        this.nameColumn.setWidth(220);
        this.messagesTable.setHeaderVisible(true);
        this.messagesTable.setSortColumn(this.nameColumn);
        this.messagesTable.setSortDirection(1024);
        this.messagesTable.setTopIndex(0);
        this.messagesTable.setLinesVisible(true);
        this.messagesTableViewer = new TableViewer(this.messagesTable);
        this.messagesTableViewer.setLabelProvider((IBaseLabelProvider)new MessageLabelProvider());
        this.messagesTableViewer.setContentProvider((IContentProvider)new MessageContentProvider());
        this.messagesTableViewer.addSelectionChangedListener((ISelectionChangedListener)new MessageSelectionChangedListener());
        this.messagesTableViewer.setComparator(new ViewerComparator());
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 150;
        this.messagesTable.setLayoutData((Object)gridData);
        this.buttonComposite.setLayoutData((Object)this.createGridData());
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.pack = false;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        this.buttonComposite.setLayout((Layout)rowLayout);
        this.createButton.setLayoutData((Object)new RowData());
        this.deleteButton.setLayoutData((Object)new RowData());
        int n = this.messagesTable.getSize().x + this.buttonComposite.getSize().x;
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = n;
        gridData.horizontalSpan = 2;
        this.createInfoLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = n;
        gridData.horizontalSpan = 2;
        this.infoLabel.setLayoutData((Object)gridData);
    }

    protected void populateSectionData() {
        this.messagesTableViewer.setInput((Object)this.input);
        ISelection iSelection = this.messagesTableViewer.getSelection();
        if (!iSelection.isEmpty()) {
            this.getManagedForm().fireSelectionChanged((IFormPart)this, iSelection);
        }
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.createButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        if (!this.isInputEditable()) {
            return;
        }
        this.createButton.setEnabled(this.isCreateAllowed());
        this.deleteButton.setEnabled(this.isDeleteAllowed());
    }

    private boolean isCreateAllowed() {
        if (!this.isInputEditable()) {
            return false;
        }
        ResourceTypeEditorInput resourceTypeEditorInput = null;
        AdaptorType adaptorType = null;
        resourceTypeEditorInput = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (resourceTypeEditorInput != null) {
            adaptorType = resourceTypeEditorInput.getPersistedResourceType().getAdaptorType();
        }
        return adaptorType != null && adaptorType != AdaptorType.NONE;
    }

    private boolean isDeleteAllowed() {
        if (!this.isInputEditable()) {
            return false;
        }
        IStructuredSelection iStructuredSelection = this.getTableSelection();
        Object object = iStructuredSelection.getFirstElement();
        return object != null;
    }

    private IStructuredSelection getTableSelection() {
        ISelection iSelection = this.messagesTableViewer.getSelection();
        return (IStructuredSelection)iSelection;
    }

    private void createNewMessage() {
        if (!this.isCreateAllowed()) {
            this.updateButtonStatus();
            return;
        }
        ResourceTypeEditorInput resourceTypeEditorInput = null;
        resourceTypeEditorInput = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (resourceTypeEditorInput == null || resourceTypeEditorInput.getPersistedResourceType() == null) {
            return;
        }
        Shell shell = this.getSection().getShell();
        long l = resourceTypeEditorInput.getPersistedResourceType().getId();
        MessageWizard messageWizard = new MessageWizard(l);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)messageWizard);
        wizardDialog.open();
        if (wizardDialog.getReturnCode() == 0) {
            Message message = messageWizard.getMessage();
            resourceTypeEditorInput.addCreatedMessage(message);
            this.markStale();
        }
    }

    private void deleteSelectedMessage() {
        if (!this.isDeleteAllowed()) {
            this.updateButtonStatus();
            return;
        }
        ResourceTypeEditorInput resourceTypeEditorInput = null;
        resourceTypeEditorInput = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (resourceTypeEditorInput == null || resourceTypeEditorInput.getPersistedResourceType() == null) {
            return;
        }
        IStructuredSelection iStructuredSelection = this.getTableSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof MessageInput) {
            MessageInput messageInput = (MessageInput)object;
            Message message = messageInput.getMessage();
            try {
                ServiceFactory serviceFactory = ServiceFactory.createFactory();
                IResourceTypeService iResourceTypeService = serviceFactory.createResourceTypeService();
                iResourceTypeService.deleteMessage(message.getId());
                resourceTypeEditorInput.removeDeletedMessage(message);
                this.markStale();
            }
            catch (Exception exception) {
                Utility.reportError("Error while deleting the selected Message.", exception);
                return;
            }
        }
    }

    private class ButtonPressListener
    extends SelectionAdapter {
        private ButtonPressListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == MessageMasterSectionPart.this.createButton) {
                MessageMasterSectionPart.this.createNewMessage();
            } else if (selectionEvent.getSource() == MessageMasterSectionPart.this.deleteButton) {
                MessageMasterSectionPart.this.deleteSelectedMessage();
            }
        }
    }

    private class MessageContentProvider
    implements IStructuredContentProvider {
        private MessageContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = null;
            if (object instanceof ResourceTypeEditorInput) {
                Set<Message> set;
                ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput)object;
                ResourceType resourceType = resourceTypeEditorInput.getResourceType();
                boolean bl = resourceTypeEditorInput.canEdit();
                Set<Message> set2 = set = resourceType != null ? resourceType.getMessages() : null;
                if (set != null) {
                    objectArray = new Object[set.size()];
                    int n = 0;
                    for (Message message : set) {
                        objectArray[n++] = new MessageInput(message, bl);
                    }
                }
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private class MessageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MessageLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (!(object instanceof MessageInput)) {
                return null;
            }
            MessageInput messageInput = (MessageInput)object;
            Message message = messageInput.getMessage();
            if (message == null) {
                return null;
            }
            String string = "";
            switch (n) {
                case 0: {
                    string = message.getUid();
                    break;
                }
                case 1: {
                    string = message.getName();
                }
            }
            if (string != null) {
                string = string.trim();
            }
            return string;
        }

        public String getText(Object object) {
            if (!(object instanceof MessageInput)) {
                return null;
            }
            MessageInput messageInput = (MessageInput)object;
            Message message = messageInput.getMessage();
            if (message == null) {
                return null;
            }
            return message.getName();
        }
    }

    private class MessageSelectionChangedListener
    implements ISelectionChangedListener {
        private MessageSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ISelection iSelection = selectionChangedEvent.getSelection();
            IManagedForm iManagedForm = MessageMasterSectionPart.this.getManagedForm();
            MessageMasterSectionPart.this.updateButtonStatus();
            iManagedForm.fireSelectionChanged((IFormPart)MessageMasterSectionPart.this, iSelection);
        }
    }
}

