/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractInVariableWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Variable;

public class InVariableTableItemWrapper
extends AbstractInVariableWrapper {
    private IMessageNodeContainer messageNodeContainer;
    private AbstractPropertySection parentPropertySection;

    public InVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, Variable variable, IMessageNodeContainer iMessageNodeContainer) {
        super(table, variable);
        this.parentPropertySection = abstractPropertySection;
        this.messageNodeContainer = iMessageNodeContainer;
        this.compositeButton.setSelection(this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null);
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(abstractPropertySection.getPart());
        boolean bl = nodeElementContainer instanceof NodeDefinition && ((NodeDefinition)nodeElementContainer).getNodeType().equals(NodeDefinitionType.SuperState);
        this.variableCombo.setEnabled(bl);
        if (bl) {
            this.fillVariableCombo();
        }
    }

    public InVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, String string, IMessageNodeContainer iMessageNodeContainer) {
        super(table, new WPVariable());
        this.parentPropertySection = abstractPropertySection;
        this.variable.setMappedName(string);
        this.messageNodeContainer = iMessageNodeContainer;
        this.compositeButton.setSelection(this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null);
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(abstractPropertySection.getPart());
        boolean bl = nodeElementContainer instanceof NodeDefinition && ((NodeDefinition)nodeElementContainer).getNodeType().equals(NodeDefinitionType.SuperState);
        this.variableCombo.setEnabled(bl);
        if (bl) {
            this.variable.setName(this.messageNodeContainer.getCompositeKey(string));
            this.fillVariableCombo();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.variableCombo) {
            this.variable.setName(this.variableCombo.getText());
            if (this.compositeButton.getSelection()) {
                this.messageNodeContainer.setCompositeKey(this.variable.getMappedName(), this.variableCombo.getText());
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.variableCombo) {
            this.setVariableName(this.variableCombo.getText());
        } else {
            super.focusLost(focusEvent);
        }
    }

    private void fillVariableCombo() {
        NodeDefinition nodeDefinition = (NodeDefinition)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        int n = 0;
        for (Variable variable : nodeDefinition.getVariables()) {
            if (variable.getMappedName() == null) continue;
            this.variableCombo.add(variable.getMappedName());
            if (this.variable.getName() != null && this.variable.getName().equals(variable.getMappedName())) {
                this.variableCombo.select(n);
            }
            ++n;
        }
    }

    private void setVariableName(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        if (this.variable.getMappedName() == null || this.variable.getMappedName().equals("")) {
            this.variable.setMappedName(this.variable.getName());
        }
        this.variable.setName(string);
    }
}

