/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractMessageContainerComposite;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.InVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.OutVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class MessageNodeContainerComposite
extends AbstractMessageContainerComposite {
    protected IMessageNodeContainer messageContainer;
    private String[] outColumnTitles = null;
    private String[] inColumnTitles = null;
    private AbstractPropertySection parentPropertySection;

    protected MessageNodeContainerComposite() {
    }

    public static MessageNodeContainerComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite, String[] stringArray, String[] stringArray2) {
        MessageNodeContainerComposite messageNodeContainerComposite = new MessageNodeContainerComposite();
        messageNodeContainerComposite.parentPropertySection = abstractPropertySection;
        messageNodeContainerComposite.init(formToolkit, stringArray, stringArray2);
        messageNodeContainerComposite.create(composite);
        return messageNodeContainerComposite;
    }

    public static MessageNodeContainerComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite) {
        return MessageNodeContainerComposite.create(abstractPropertySection, formToolkit, composite, new String[]{"Name", "Attachment", "Value", "Node Definition Variable"}, new String[]{"Name", "Node Definition Variable", "Composite Key"});
    }

    protected void init(FormToolkit formToolkit, String[] stringArray, String[] stringArray2) {
        super.init(formToolkit);
        this.outColumnTitles = stringArray;
        this.inColumnTitles = stringArray2;
    }

    public IMessageNodeContainer getMessageContainer() {
        return this.messageContainer;
    }

    public void setMessageContainer(IMessageNodeContainer iMessageNodeContainer) {
        this.unhookListeners();
        this.messageContainer = iMessageNodeContainer;
        this.clearControls();
        if (iMessageNodeContainer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    protected void refreshTables() {
        AbstractVariableTableItemWrapper abstractVariableTableItemWrapper;
        this.outVariablesTable.removeAll();
        List<WPVariable> list = this.messageContainer.getOutgoingVariables();
        for (WPVariable wPVariable : list) {
            abstractVariableTableItemWrapper = new OutVariableTableItemWrapper(this.parentPropertySection, this.outVariablesTable, wPVariable);
            this.outVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        for (NameValuePair nameValuePair : this.messageContainer.getConstants()) {
            abstractVariableTableItemWrapper = new OutVariableTableItemWrapper(this.parentPropertySection, this.outVariablesTable, nameValuePair.getName(), nameValuePair.getValue());
            this.outVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        this.inVariablesTable.removeAll();
        list = this.messageContainer.getIncomingVariables();
        for (WPVariable wPVariable : list) {
            abstractVariableTableItemWrapper = new InVariableTableItemWrapper(this.parentPropertySection, this.inVariablesTable, wPVariable, this.messageContainer);
            this.inVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        for (String string : this.messageContainer.getCompositeKeys().keySet()) {
            abstractVariableTableItemWrapper = new InVariableTableItemWrapper(this.parentPropertySection, this.inVariablesTable, string, this.messageContainer);
            this.inVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
    }

    protected void initializeOutTableColumns() {
        TableLayout tableLayout = (TableLayout)this.outVariablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.outVariablesTable, 16384);
        tableColumn2.setText(this.outColumnTitles[0]);
        tableColumn2.pack();
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.outVariablesTable, 16384);
        tableColumn3.setText(this.outColumnTitles[1]);
        tableColumn3.setAlignment(0x1000000);
        tableColumn3.pack();
        ColumnWeightData columnWeightData3 = new ColumnWeightData(9);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        TableColumn tableColumn4 = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn4.setText(this.outColumnTitles[2]);
        tableColumn4.pack();
        ColumnWeightData columnWeightData4 = new ColumnWeightData(12);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
        TableColumn tableColumn5 = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn5.setText(this.outColumnTitles[3]);
        tableColumn5.pack();
        ColumnWeightData columnWeightData5 = new ColumnWeightData(12);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData5);
    }

    protected void initializeInTableColumns() {
        TableLayout tableLayout = (TableLayout)this.inVariablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.inVariablesTable, 16384);
        tableColumn2.setText(this.inColumnTitles[0]);
        tableColumn2.pack();
        ColumnWeightData columnWeightData2 = new ColumnWeightData(14);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.inVariablesTable, 0x1000000);
        tableColumn3.setText(this.inColumnTitles[1]);
        tableColumn3.pack();
        ColumnWeightData columnWeightData3 = new ColumnWeightData(14);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        TableColumn tableColumn4 = new TableColumn(this.inVariablesTable, 0x1000000);
        tableColumn4.setText(this.inColumnTitles[2]);
        tableColumn4.pack();
        ColumnWeightData columnWeightData4 = new ColumnWeightData(6);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
    }
}

