/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.xml.NodeDefinitionDomAdapter;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class NodeDefinitionTypeConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo nodeDefinitionTypeCombo;
    private Label nodeDefinitionTypeLabel;
    private NodeDefinition nodeDefinition;
    private List<NodeDefinitionDTO> definitions;
    private AbstractPropertySection parentPropertySection;

    private NodeDefinitionTypeConfigurationComposite() {
    }

    public static NodeDefinitionTypeConfigurationComposite create(AbstractPropertySection abstractPropertySection, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        NodeDefinitionTypeConfigurationComposite nodeDefinitionTypeConfigurationComposite = new NodeDefinitionTypeConfigurationComposite();
        nodeDefinitionTypeConfigurationComposite.parentPropertySection = abstractPropertySection;
        nodeDefinitionTypeConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        nodeDefinitionTypeConfigurationComposite.parent = composite;
        nodeDefinitionTypeConfigurationComposite.create();
        return nodeDefinitionTypeConfigurationComposite;
    }

    public void setResourceGroupElement(NodeDefinition nodeDefinition) {
        if (this.nodeDefinition == nodeDefinition) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.nodeDefinition = nodeDefinition;
        if (nodeDefinition != null) {
            this.updateControls();
            this.hookSelectionListener();
            this.fillNodeDefinitionTypeCombo();
            if (this.nodeDefinition.getDefinitionName() != null && this.nodeDefinitionTypeCombo.indexOf(this.nodeDefinition.getDefinitionName()) != -1) {
                this.nodeDefinitionTypeCombo.setText(this.nodeDefinition.getDefinitionName());
                this.nodeDefinitionTypeCombo.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.nodeDefinitionTypeCombo) {
            long l = this.definitions.get(this.nodeDefinitionTypeCombo.getSelectionIndex()).getId();
            NodeDefinitionDTO nodeDefinitionDTO = ServiceFactory.createFactory().createNodeDefinitionService().getNodeDefinitionForView(l);
            NodeDefinition nodeDefinition = new NodeDefinition();
            nodeDefinition.setNodeType(nodeDefinitionDTO.getType());
            NodeDefinitionDomAdapter nodeDefinitionDomAdapter = (NodeDefinitionDomAdapter)Utility.getAdapterFromString(nodeDefinitionDTO.getXml(), this.nodeDefinition.getFactory());
            nodeDefinitionDomAdapter.initialize(nodeDefinition);
            if (!this.isNodeDefinitionValid(nodeDefinition)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Node Definition " + this.nodeDefinitionTypeCombo.getText() + " is not valid."));
                nodeDefinition.removePropertyChangeListener((PropertyChangeListener)((Object)nodeDefinitionDomAdapter));
                this.nodeDefinitionTypeCombo.select(-1);
                return;
            }
            nodeDefinition.removePropertyChangeListener((PropertyChangeListener)((Object)nodeDefinitionDomAdapter));
            this.nodeDefinition.setNodeType(nodeDefinitionDTO.getType());
            this.nodeDefinition.setId(nodeDefinitionDTO.getId());
            this.nodeDefinition.setResourceType(nodeDefinitionDTO.getResourceType().getId());
            String string = this.nodeDefinition.getName();
            nodeDefinitionDomAdapter.initialize(this.nodeDefinition);
            this.nodeDefinition.removePropertyChangeListener((PropertyChangeListener)((Object)nodeDefinitionDomAdapter));
            this.nodeDefinition.setName(string);
            this.nodeDefinition.setDefinitionName(this.nodeDefinitionTypeCombo.getItem(this.nodeDefinitionTypeCombo.getSelectionIndex()));
            if (this.parentPropertySection.getPart() instanceof NodeDefinitionEditor) {
                this.clearSingleNodeNodeDefinition(this.nodeDefinition);
            }
            this.nodeDefinitionTypeCombo.setEnabled(false);
        }
    }

    private void hookSelectionListener() {
        this.nodeDefinitionTypeCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.nodeDefinitionTypeCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.nodeDefinitionTypeCombo.setEnabled(false);
    }

    private void updateControls() {
        this.nodeDefinitionTypeCombo.setEnabled(true);
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.nodeDefinitionTypeLabel = new Label(composite, 0);
        this.nodeDefinitionTypeLabel.setText("Type");
        this.nodeDefinitionTypeLabel.setLayoutData((Object)this.createNodeDefinitionTypeLabelLayoutData());
        this.nodeDefinitionTypeLabel.setBackground(ColorConstants.white);
        this.nodeDefinitionTypeLabel.pack();
        this.nodeDefinitionTypeCombo = this.widgetFactory.createCCombo(composite, 780);
        this.nodeDefinitionTypeCombo.setLayoutData((Object)this.createNodeDefinitionTypeComboLayoutData());
        this.nodeDefinitionTypeCombo.pack();
    }

    private FormData createNodeDefinitionTypeLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 2);
        return formData;
    }

    private FormData createNodeDefinitionTypeComboLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private void fillNodeDefinitionTypeCombo() {
        if (!this.nodeDefinitionTypeCombo.isEnabled()) {
            this.nodeDefinitionTypeCombo.setText(this.nodeDefinition.getDefinitionName());
            return;
        }
        this.nodeDefinitionTypeCombo.removeAll();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition object = (NodeDefinition)nodeElementContainer;
            this.definitions = ServiceFactory.createFactory().createNodeDefinitionService().getSingleNodeDefinitionsByResourceType(object.getResourceType());
        } else {
            this.definitions = ServiceFactory.createFactory().createNodeDefinitionService().getAllNodeDefinitions();
        }
        for (NodeDefinitionDTO nodeDefinitionDTO : this.definitions) {
            this.nodeDefinitionTypeCombo.add(nodeDefinitionDTO.getName());
        }
    }

    private boolean isNodeDefinitionValid(NodeDefinition nodeDefinition) {
        return ValidationServiceFactory.createFactory().createValidationService().validateNodeDefinition(nodeDefinition).size() == 0;
    }

    private void clearSingleNodeNodeDefinition(NodeDefinition nodeDefinition) {
        this.nodeDefinition.setDueDate(null);
        this.nodeDefinition.setDuration(null);
        this.nodeDefinition.setTaskDuration(null);
    }
}

