/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class ConstantsComposite {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label containerLabel;
    private Table constantsTable;
    private IMessageNodeContainer messageNodeContainer;
    private String[] columnTitles = null;

    public static ConstantsComposite create(FormToolkit formToolkit, Composite composite, String[] stringArray) {
        ConstantsComposite constantsComposite = new ConstantsComposite();
        constantsComposite.widgetFactory = formToolkit;
        constantsComposite.parent = composite;
        constantsComposite.columnTitles = stringArray;
        constantsComposite.create();
        return constantsComposite;
    }

    public static ConstantsComposite create(FormToolkit formToolkit, Composite composite) {
        return ConstantsComposite.create(formToolkit, composite, new String[]{"Name", "Value"});
    }

    private ConstantsComposite() {
    }

    public void setMessageNodeContainer(IMessageNodeContainer iMessageNodeContainer) {
        this.messageNodeContainer = iMessageNodeContainer;
        this.clearControls();
        if (iMessageNodeContainer != null) {
            this.updateControls();
        }
    }

    private void clearControls() {
        this.constantsTable.removeAll();
    }

    private void updateControls() {
        this.refreshTable();
    }

    private void create() {
        this.containerLabel = this.widgetFactory.createLabel(this.parent, "Constants :");
        this.constantsTable = this.widgetFactory.createTable(this.parent, 66304);
        this.containerLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.constantsTable.setLayoutData((Object)this.createConstantsTableLayoutData());
        this.initializeConstantsTable();
    }

    private void initializeConstantsTable() {
        this.constantsTable.setHeaderVisible(true);
        this.constantsTable.setLinesVisible(true);
        this.constantsTable.setLayout((Layout)new AutoResizeTableLayout(this.constantsTable));
        this.initializeConstantsTableColumns();
    }

    private void initializeConstantsTableColumns() {
        TableLayout tableLayout = (TableLayout)this.constantsTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.constantsTable, 16384);
        tableColumn.setText(this.columnTitles[0]);
        ColumnWeightData columnWeightData = new ColumnWeightData(15);
        columnWeightData.resizable = false;
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.constantsTable, 16384);
        tableColumn2.setText(this.columnTitles[1]);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        columnWeightData2.resizable = false;
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
    }

    private FormData createMessageLabelLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createConstantsTableLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.containerLabel, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -10);
        return formData;
    }

    private void refreshTable() {
        this.constantsTable.removeAll();
        for (NameValuePair nameValuePair : this.messageNodeContainer.getConstants()) {
            TableItem tableItem = new TableItem(this.constantsTable, 0);
            tableItem.setText(new String[]{nameValuePair.getName(), nameValuePair.getValue()});
        }
    }
}

