/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Variable;

public class NodeDefinitionVariableTableItemWrapper
extends AbstractVariableTableItemWrapper {
    private Button keyButton;
    private Button attachmentButton;
    private CCombo typeCombo;
    private CCombo processNameCombo;
    private IMessageNodeContainer messageNodeContainer;
    private AbstractPropertySection parentPropertySection;
    private boolean required = false;

    public NodeDefinitionVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, Variable variable, IMessageNodeContainer iMessageNodeContainer) {
        this(abstractPropertySection, table, variable, iMessageNodeContainer, false);
    }

    public NodeDefinitionVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, Variable variable, IMessageNodeContainer iMessageNodeContainer, boolean bl) {
        super(table, variable);
        this.parentPropertySection = abstractPropertySection;
        this.messageNodeContainer = iMessageNodeContainer;
        this.required = bl;
        this.mappedNameText.setEditable(abstractPropertySection.getPart() instanceof NodeDefinitionEditor);
        this.tableItem.setText(2, this.getName());
        this.initializeProcessNameCombo(table);
        this.initializeAttachmentButton(table);
        this.initializeTypeCombo(table);
        this.initializeKeyButton(table);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.widgetDisposed(disposeEvent);
        this.tableItem.removeDisposeListener((DisposeListener)this);
        this.attachmentButton.removeSelectionListener((SelectionListener)this);
        this.attachmentButton.dispose();
        this.typeCombo.removeSelectionListener((SelectionListener)this);
        this.typeCombo.dispose();
        if (this.keyButton != null) {
            this.keyButton.removeSelectionListener((SelectionListener)this);
            if (!this.keyButton.isDisposed()) {
                this.keyButton.dispose();
            }
        }
        if (this.processNameCombo != null && !this.processNameCombo.isDisposed()) {
            this.processNameCombo.removeSelectionListener((SelectionListener)this);
            this.processNameCombo.removeFocusListener((FocusListener)this);
            this.processNameCombo.dispose();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.typeCombo) {
            this.variable.setType(this.typeCombo.getText());
        } else if (selectionEvent.widget == this.processNameCombo) {
            if (this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null) {
                this.messageNodeContainer.setCompositeKey(this.variable.getMappedName(), this.processNameCombo.getText());
            }
            this.variable.setName(this.processNameCombo.getText());
        }
        if (selectionEvent.widget == this.keyButton || selectionEvent.widget == this.attachmentButton) {
            this.variable.setAccess(this.calculateAccessString());
        }
    }

    private String getName() {
        return this.variable.getName() == null ? "" : this.variable.getName();
    }

    protected String getMappedName() {
        String string = super.getMappedName();
        if (string != null && string.trim().length() > 0 && this.required) {
            string = String.valueOf(string) + " *";
        }
        return string;
    }

    private String calculateAccessString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("read,write,");
        if (this.keyButton.getSelection()) {
            stringBuffer.append(" compositeKey,");
        }
        if (this.attachmentButton.getSelection()) {
            stringBuffer.append("attachment ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private void initializeAttachmentButton(Table table) {
        this.attachmentButton = this.createButton(table, 3);
        this.attachmentButton.addSelectionListener((SelectionListener)this);
        this.attachmentButton.setSelection(this.isAttachment(this.variable.getMappedName()));
        this.attachmentButton.setEnabled(false);
        this.attachmentButton.pack();
    }

    private void initializeKeyButton(Table table) {
        this.keyButton = this.createButton(table, 5);
        this.keyButton.addSelectionListener((SelectionListener)this);
        this.keyButton.setSelection(this.isCompositeKey(this.variable.getMappedName()));
        this.keyButton.setEnabled(false);
        this.keyButton.pack();
    }

    private void initializeTypeCombo(Table table) {
        this.typeCombo = this.createCombo(table, 4);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        if (this.parentPropertySection.getPart() instanceof WatchPointTemplateEditor) {
            this.typeCombo.setEnabled(false);
        } else {
            int n = 0;
            while (n < DataType.values().length) {
                this.typeCombo.add(DataType.values()[n].toString());
                ++n;
            }
        }
        if (this.variable.getType() != null) {
            this.typeCombo.setText(this.variable.getType());
        }
        this.typeCombo.pack();
    }

    private void initializeProcessNameCombo(Table table) {
        this.processNameCombo = this.createCombo(table, 2);
        this.processNameCombo.addSelectionListener((SelectionListener)this);
        this.processNameCombo.addFocusListener((FocusListener)this);
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        if (nodeElementContainer instanceof NodeDefinition) {
            this.processNameCombo.setEnabled(false);
        } else {
            this.fillVariableCombo();
        }
        if (this.processNameCombo.getText().equals("") && this.variable.getName() != null) {
            this.processNameCombo.setText(this.variable.getName());
        }
    }

    private void fillVariableCombo() {
        StartState startState;
        WorkflowTemplate workflowTemplate = (WorkflowTemplate)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        if (!this.required) {
            this.processNameCombo.add("");
        }
        if ((startState = workflowTemplate.getStartState()) == null || startState.getTask() == null) {
            return;
        }
        Controller controller = startState.getTask().getController();
        String string = this.variable.getType();
        Variable[] variableArray = controller.getVariables();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            WPVariable wPVariable = (WPVariable)variable;
            if (wPVariable.getName() != null && (string == null || string.equals("") || string.equals(wPVariable.getType()))) {
                this.processNameCombo.add(wPVariable.getName());
            }
            ++n2;
        }
    }

    private boolean isCompositeKey(String string) {
        NodeElement[] nodeElementArray = ((NodeElementContainer)this.messageNodeContainer).getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            Iterator<String> iterator = null;
            if (nodeElement instanceof IMessageNodeContainer) {
                for (String string2 : ((IMessageNodeContainer)nodeElement).getCompositeKeys().keySet()) {
                    String string3 = ((IMessageNodeContainer)nodeElement).getCompositeKey(string2);
                    if (!string3.equals(string)) continue;
                    return true;
                }
            } else if (nodeElement instanceof IMessageContainer) {
                for (String string2 : ((IMessageContainer)nodeElement).getCompositeKeys().keySet()) {
                    if (!string.equals(string2)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isAttachment(String string) {
        NodeElement[] nodeElementArray = ((NodeElementContainer)this.messageNodeContainer).getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof IMessageNodeContainer) {
                for (WPVariable wPVariable : ((IMessageNodeContainer)nodeElement).getVariables()) {
                    if (!wPVariable.isAttachment() || wPVariable.getName() == null || !wPVariable.getName().equals(string)) continue;
                    return true;
                }
            } else if (nodeElement instanceof IMessageContainer) {
                for (WPVariable wPVariable : ((IMessageContainer)nodeElement).getOutgoingVariables()) {
                    if (!wPVariable.isAttachment() || wPVariable.getMappedName() == null || !wPVariable.getMappedName().equals(string)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

