/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class UidConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo uidCombo;
    private Label uidLabel;
    private IMessageNodeContainer messageContainerNode;
    private List<Message> messages;
    private AbstractPropertySection parentPropertySection;

    private UidConfigurationComposite() {
    }

    public static UidConfigurationComposite create(AbstractPropertySection abstractPropertySection, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        UidConfigurationComposite uidConfigurationComposite = new UidConfigurationComposite();
        uidConfigurationComposite.parentPropertySection = abstractPropertySection;
        uidConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        uidConfigurationComposite.parent = composite;
        uidConfigurationComposite.create();
        return uidConfigurationComposite;
    }

    public void setUidElement(IMessageNodeContainer iMessageNodeContainer) {
        this.clearControls();
        this.messageContainerNode = iMessageNodeContainer;
        if (iMessageNodeContainer != null) {
            if (this.uidCombo.isEnabled()) {
                this.fillUidCombo();
            }
            this.updateControls();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.uidCombo && this.messageContainerNode != null) {
            String string = this.getUID(this.uidCombo.getText());
            if (!Utility.isOutgoingMessage(string) && this.hasAttachment()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"This is an incoming message and can not have an attachment. Please remove the attachment variable first before selecting this message.");
                this.uidCombo.setText(this.getMessageName(this.messageContainerNode.getUid()));
                return;
            }
            this.messageContainerNode.setUid(string);
        }
    }

    private String getUID(String string) {
        for (Message message : this.messages) {
            if (!message.getName().equals(string)) continue;
            return message.getUid();
        }
        return "";
    }

    private String getMessageName(String string) {
        for (Message message : this.messages) {
            if (!message.getUid().equals(string)) continue;
            return message.getName();
        }
        return "";
    }

    private void clearControls() {
        this.uidCombo.setText("");
    }

    private void updateControls() {
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(iWorkbenchPart);
        if (nodeElementContainer == null) {
            throw new UIException("Current editor does not have a node element container associated with it.");
        }
        boolean bl = ((NodeElementContainer)this.messageContainerNode).getElementId().equals(nodeElementContainer.getElementId()) && this.messageContainerNode instanceof NamedElement && nodeElementContainer instanceof NodeDefinition && ((NamedElement)this.messageContainerNode).getName().equals(((NamedElement)nodeElementContainer).getName());
        this.uidCombo.setEnabled(bl);
        String string = this.messageContainerNode.getUid();
        if (string != null) {
            this.setUIDInCombo();
        }
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.uidLabel = new Label(composite, 0);
        this.uidLabel.setLayoutData((Object)this.createUidpLabelLayoutData());
        this.uidLabel.setText("Message Name");
        this.uidLabel.pack();
        this.uidCombo = this.widgetFactory.createCCombo(this.parent, 780);
        this.uidCombo.setLayoutData((Object)this.createUidComboLayoutData());
        this.uidCombo.addSelectionListener((SelectionListener)this);
        this.uidCombo.pack();
    }

    private FormData createUidpLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createUidComboLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.uidLabel, 95);
        formData.top = new FormAttachment(0, 0);
        formData.width = 150;
        return formData;
    }

    private void fillUidCombo() {
        this.uidCombo.removeAll();
        IResourceTypeService iResourceTypeService = ServiceFactory.createFactory().createResourceTypeService();
        long l = this.messageContainerNode.getResourceType();
        long l2 = this.getNodeDefinitionId();
        this.messages = l2 == 0L ? iResourceTypeService.getUnusedResourceTypeMessages(l) : iResourceTypeService.getUnusedResourceTypeMessages(l, l2);
        if (this.messageContainerNode != null && this.messageContainerNode.getUid() != null && this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        Collections.sort(this.messages, new Comparator<Message>(){

            @Override
            public int compare(Message message, Message message2) {
                if (message.getName() == null && message2.getName() == null) {
                    return 0;
                }
                if (message.getName() == null) {
                    return -1;
                }
                if (message2.getName() == null) {
                    return 1;
                }
                return message.getName().compareToIgnoreCase(message2.getName());
            }
        });
        for (Message message : this.messages) {
            this.uidCombo.add(message.getName());
        }
    }

    private void setUIDInCombo() {
        if (this.messageContainerNode == null || this.messageContainerNode.getUid() == null) {
            return;
        }
        IResourceTypeService iResourceTypeService = ServiceFactory.createFactory().createResourceTypeService();
        Message message = iResourceTypeService.findMessageByUID(((NodeDefinition)this.messageContainerNode).getUid());
        this.uidCombo.setText(message.getName());
    }

    private long getNodeDefinitionId() {
        if (this.parentPropertySection.getPart() instanceof NodeDefinitionEditor) {
            return ((NodeDefinitionEditor)this.parentPropertySection.getPart()).getNodeDefinitionDTOId();
        }
        return 0L;
    }

    private boolean hasAttachment() {
        List<WPVariable> list = this.messageContainerNode.getOutgoingVariables();
        for (WPVariable wPVariable : list) {
            if (!wPVariable.isAttachment()) continue;
            return true;
        }
        return false;
    }
}

