/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.properties.TaskNodeActionElementComposite;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.common.model.GenericElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentTableItemWrapper
implements DisposeListener,
FocusListener {
    private TableItem tableItem;
    private Text nameText;
    private Text valueText;
    private TaskNodeActionElementComposite parent;
    private GenericElement genericElement;
    private IValidationService validationService;

    public ArgumentTableItemWrapper(TaskNodeActionElementComposite taskNodeActionElementComposite, Table table, GenericElement genericElement, boolean bl) {
        this.parent = taskNodeActionElementComposite;
        this.genericElement = genericElement;
        this.validationService = ValidationServiceFactory.createFactory().createValidationService();
        this.initializeTableItem(table);
        this.initializeNameText(table);
        this.initializeValueText(table);
        this.nameText.setEnabled(bl);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.nameText) {
            if (this.genericElement.getName().equals(this.nameText.getText())) {
                return;
            }
            if (this.isNameValid()) {
                this.genericElement.setName(this.nameText.getText());
            } else {
                this.nameText.setText(this.genericElement.getName());
            }
        } else if (focusEvent.widget == this.valueText) {
            if (this.genericElement.getValue().equals(this.valueText.getText())) {
                return;
            }
            if (this.isValueValid()) {
                this.genericElement.setValue(this.valueText.getText());
            } else {
                this.valueText.setText(this.genericElement.getValue());
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.widget == this.nameText || focusEvent.widget == this.valueText) {
            this.tableItem.getParent().setSelection(this.tableItem);
            if (this.nameText.isEnabled()) {
                this.parent.setRemoveButtonEnable(true);
            }
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return;
        }
        if (this.valueText == null || this.valueText.isDisposed()) {
            return;
        }
        this.nameText.removeFocusListener((FocusListener)this);
        this.nameText.dispose();
        this.valueText.removeFocusListener((FocusListener)this);
        this.valueText.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeNameText(Table table) {
        this.nameText = this.createText(table, 0);
        FormData formData = new FormData();
        this.nameText.setLayoutData((Object)formData);
        this.nameText.addFocusListener((FocusListener)this);
        this.nameText.setText(this.getArgumentName());
        this.nameText.setEditable(true);
    }

    protected void initializeValueText(Table table) {
        this.valueText = this.createText(table, 1);
        FormData formData = new FormData();
        this.valueText.setLayoutData((Object)formData);
        this.valueText.addFocusListener((FocusListener)this);
        this.valueText.setText(this.getArgumentValue());
        this.valueText.setEditable(true);
    }

    protected Text createText(Table table, int n) {
        TableEditor tableEditor = new TableEditor(table);
        Text text = new Text((Composite)table, 0);
        text.setVisible(true);
        text.pack();
        tableEditor.minimumWidth = text.getSize().x;
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)text, this.tableItem, n);
        return text;
    }

    public String getArgumentName() {
        return this.genericElement.getName();
    }

    public String getArgumentValue() {
        return this.genericElement.getValue();
    }

    private boolean isNameValid() {
        String string = this.nameText.getText();
        GenericElement genericElement = new GenericElement();
        genericElement.setName(string);
        List<ValidationMessage> list = null;
        list = this.validationService.validateActionVariableName(genericElement);
        boolean bl = this.isValid(list);
        boolean bl2 = false;
        if (!bl) {
            this.displayValidationErrors(list);
        } else {
            bl2 = this.checkDuplicateName(string);
            if (bl2) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)(String.valueOf(string) + " is a duplicate name. Duplicate names are not allowed."));
            }
        }
        return bl && !bl2;
    }

    private boolean isValueValid() {
        boolean bl = true;
        AbstractTaskNode abstractTaskNode = this.parent.getTaskNode();
        if (!(abstractTaskNode instanceof AutomaticTaskNode)) {
            return bl;
        }
        AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)abstractTaskNode;
        GenericElement genericElement = new GenericElement();
        genericElement.setName(this.nameText.getText());
        genericElement.setValue(this.valueText.getText());
        List<ValidationMessage> list = null;
        list = this.validationService.validateActionVariableValue(automaticTaskNode, genericElement);
        bl = this.isValid(list);
        if (!bl) {
            this.displayValidationErrors(list);
        }
        return bl;
    }

    private boolean isValid(List<ValidationMessage> list) {
        return list == null || list.size() == 0;
    }

    private void displayValidationErrors(List<ValidationMessage> list) {
        Shell shell = Display.getCurrent().getActiveShell();
        StringBuilder stringBuilder = new StringBuilder();
        ValidationMessages validationMessages = null;
        try {
            validationMessages = ValidationMessages.getInstance();
        }
        catch (Exception exception) {
            throw new UIException("Could not load the validation messages.", exception);
        }
        boolean bl = true;
        for (ValidationMessage validationMessage : list) {
            if (!bl) {
                stringBuilder.append(System.getProperty("line.separator"));
            } else {
                bl = false;
            }
            stringBuilder.append(validationMessages.getMessage(validationMessage));
        }
        MessageDialog.openError((Shell)shell, (String)"Error", (String)stringBuilder.toString());
    }

    private boolean checkDuplicateName(String string) {
        GenericElement[] genericElementArray = this.parent.getTaskNode().getAction().getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement genericElement = genericElementArray[n2];
            if (genericElement.getName().equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

