/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.properties.template.ProtectionKeyTableItemWrapper;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class PKContainerConfigurationComposite
implements SelectionListener {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label pkLabel;
    private Table pkTable;
    private Button addButton;
    private Button removeButton;
    private IProtectionKeyElement protectionKeyElement;
    private String[] columnTitles = null;
    private AbstractPropertySection parentPropertySection;

    public static PKContainerConfigurationComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite, String[] stringArray) {
        PKContainerConfigurationComposite pKContainerConfigurationComposite = new PKContainerConfigurationComposite();
        pKContainerConfigurationComposite.parentPropertySection = abstractPropertySection;
        pKContainerConfigurationComposite.widgetFactory = formToolkit;
        pKContainerConfigurationComposite.parent = composite;
        pKContainerConfigurationComposite.columnTitles = stringArray;
        pKContainerConfigurationComposite.create();
        return pKContainerConfigurationComposite;
    }

    public static PKContainerConfigurationComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite) {
        return PKContainerConfigurationComposite.create(abstractPropertySection, formToolkit, composite, new String[]{"Name"});
    }

    private PKContainerConfigurationComposite() {
    }

    public void setProtectionKeyElement(IProtectionKeyElement iProtectionKeyElement) {
        this.unhookListeners();
        this.protectionKeyElement = iProtectionKeyElement;
        this.clearControls();
        if (iProtectionKeyElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (selectionEvent.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else if (selectionEvent.widget == this.pkTable) {
            this.handlePKTableSelected(selectionEvent);
        }
    }

    public void setRemoveButtonEnable(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    private void hookListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.pkTable.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.pkTable.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.pkTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void updateControls() {
        this.addButton.setEnabled(true);
        this.refreshTable();
    }

    private void create() {
        this.pkLabel = this.widgetFactory.createLabel(this.parent, "Define the protection keys :");
        this.pkTable = this.widgetFactory.createTable(this.parent, 66304);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.removeButton.setEnabled(false);
        this.pkLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.pkTable.setLayoutData((Object)this.createPKTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initializePKTable();
    }

    private void initializePKTable() {
        this.pkTable.setHeaderVisible(true);
        this.pkTable.setLinesVisible(true);
        this.pkTable.setLayout((Layout)new AutoResizeTableLayout(this.pkTable));
        this.initializeTaskTableColumns();
    }

    private void initializeTaskTableColumns() {
        TableLayout tableLayout = (TableLayout)this.pkTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.pkTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.pkTable, 16384);
        tableColumn2.setText(this.columnTitles[0]);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        columnWeightData2.resizable = false;
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
    }

    private FormData createMessageLabelLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createPKTableLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.pkLabel, 5);
        formData.left = new FormAttachment(0, 85);
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment((Control)this.removeButton, -5);
        return formData;
    }

    private FormData createAddButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.pkTable, 0);
        formData.top.alignment = 128;
        formData.left = new FormAttachment((Control)this.removeButton, 0);
        formData.left.alignment = 16384;
        formData.right = new FormAttachment(90, -5);
        return formData;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.addButton, 5);
        formData.right = new FormAttachment(90, -5);
        return formData;
    }

    private void handleAddButtonSelected() {
        ProtectionKey protectionKey = this.createProtectionKey();
        this.protectionKeyElement.addProtectionKey(protectionKey);
        ProtectionKeyTableItemWrapper protectionKeyTableItemWrapper = new ProtectionKeyTableItemWrapper(this.parentPropertySection, this, this.pkTable, protectionKey);
        this.pkTable.setSelection(protectionKeyTableItemWrapper.getTableItem());
        protectionKeyTableItemWrapper.editCell(1);
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private void handleRemoveButtonSelected() {
        TableItem tableItem = this.pkTable.getItem(this.pkTable.getSelectionIndex());
        ProtectionKeyTableItemWrapper protectionKeyTableItemWrapper = (ProtectionKeyTableItemWrapper)tableItem.getData();
        this.protectionKeyElement.removeProtectionKey(protectionKeyTableItemWrapper.getProtectionKey());
        this.refreshTable();
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private void refreshTable() {
        this.pkTable.removeAll();
        Set<ProtectionKey> set = this.protectionKeyElement.getProtectionKeys();
        if (set != null) {
            for (ProtectionKey protectionKey : set) {
                new ProtectionKeyTableItemWrapper(this.parentPropertySection, this, this.pkTable, protectionKey);
            }
        }
    }

    private void handlePKTableSelected(SelectionEvent selectionEvent) {
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private ProtectionKey createProtectionKey() {
        return (ProtectionKey)this.protectionKeyElement.getFactory().createById("org.jbpm.gd.jpdl.protectionKey");
    }
}

