/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.properties.template.PKContainerConfigurationComposite;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionKeyTableItemWrapper
implements DisposeListener,
SelectionListener,
FocusListener {
    protected TableItem tableItem;
    protected CCombo nameCombo;
    protected ProtectionKey protectionKey;
    protected PKContainerConfigurationComposite parent;
    private AbstractPropertySection parentPropertySection;

    public ProtectionKeyTableItemWrapper(AbstractPropertySection abstractPropertySection, PKContainerConfigurationComposite pKContainerConfigurationComposite, Table table, ProtectionKey protectionKey) {
        this.protectionKey = protectionKey;
        this.parent = pKContainerConfigurationComposite;
        this.parentPropertySection = abstractPropertySection;
        this.initializeTableItem(table);
        this.initializeNameCombo(table);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.cancelEditing();
        if (focusEvent.widget == this.nameCombo) {
            String string = this.nameCombo.getText().toUpperCase();
            this.protectionKey.setName(string);
            this.nameCombo.setText(string);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.widget == this.nameCombo) {
            this.tableItem.getParent().setSelection(this.tableItem);
            this.parent.setRemoveButtonEnable(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.nameCombo) {
            this.protectionKey.setName(this.nameCombo.getText());
            this.applyName();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.nameCombo == null || this.nameCombo.isDisposed()) {
            return;
        }
        this.nameCombo.removeSelectionListener((SelectionListener)this);
        this.nameCombo.removeFocusListener((FocusListener)this);
        this.nameCombo.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public ProtectionKey getProtectionKey() {
        return this.protectionKey;
    }

    public void editCell(int n) {
        if (n == 1) {
            this.editName();
        }
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeNameCombo(Table table) {
        this.nameCombo = this.createCombo(table, 1);
        this.nameCombo.setTextLimit(50);
        FormData formData = new FormData();
        formData.width = 85;
        this.nameCombo.setLayoutData((Object)formData);
        this.nameCombo.addSelectionListener((SelectionListener)this);
        this.nameCombo.addFocusListener((FocusListener)this);
        this.nameCombo.setText(this.getName());
        this.nameCombo.setEditable(true);
        this.fillProtectionKeyCombo();
        if (this.nameCombo.getSelectionIndex() == -1) {
            this.nameCombo.setText(this.getName());
        }
    }

    protected CCombo createCombo(Table table, int n) {
        TableEditor tableEditor = new TableEditor(table);
        CCombo cCombo = new CCombo((Composite)table, 780);
        cCombo.pack();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)cCombo, this.tableItem, n);
        return cCombo;
    }

    protected void editName() {
        this.nameCombo.setVisible(true);
        this.nameCombo.setText(this.getName());
        this.nameCombo.setFocus();
    }

    protected void cancelEditing() {
        this.applyName();
    }

    protected void applyName() {
        if (this.nameCombo == null) {
            return;
        }
        this.tableItem.setText(1, this.getName());
    }

    protected String getName() {
        return this.protectionKey.getName() == null ? "" : this.protectionKey.getName();
    }

    private void fillProtectionKeyCombo() {
        IResourceGroupService iResourceGroupService = ServiceFactory.createFactory().createResourceGroupService();
        int n = 0;
        for (String string : this.getResourceGroups()) {
            String string2 = iResourceGroupService.getProtectionKeyByResourceGroupName(string).getName();
            if (this.arrayContains(this.nameCombo.getItems(), string2)) continue;
            this.nameCombo.add(string2);
            if (string2.equals(this.protectionKey.getName())) {
                this.nameCombo.select(n);
            }
            ++n;
        }
    }

    private Set<String> getResourceGroups() {
        HashSet<String> hashSet = new HashSet<String>();
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(iWorkbenchPart);
        if (nodeElementContainer == null) {
            throw new UIException("Current editor does not have a node element container associated with it.");
        }
        NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)nodeElement).getResourceGroup()) != null && resourceGroup.getName() != null && !resourceGroup.getName().trim().equals("")) {
                hashSet.add(((IResourceGroupElement)nodeElement).getResourceGroup().getName());
            }
            ++n2;
        }
        return hashSet;
    }

    private boolean arrayContains(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

