/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ReferenceDeletionException;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.nodedefinition.NodeDefinitionLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewNodeDefinitionWizard;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionExplorer
extends AbstractTreeViewExplorer {
    private static final Logger logger = Logger.getLogger(NodeDefinitionExplorer.class);
    private static final String LINE_SEPRATOR = "line.separator";
    INodeDefinitionService nodeDefinitionService;
    private IResourceTypeService rtService;
    private Map<ResourceType, List<NodeDefinitionDTO>> resourceTypeNodeDefinitions = new HashMap<ResourceType, List<NodeDefinitionDTO>>();
    private NodeDefinitionContentProvider contentProvider = new NodeDefinitionContentProvider();

    public NodeDefinitionExplorer() {
        this.nodeDefinitionService = ServiceFactory.createFactory().createNodeDefinitionService();
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    @Override
    protected void create() {
        if (!Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true)) {
            return;
        }
        this.openCreateWizard();
        this.refresh();
    }

    @Override
    protected void delete() {
        boolean bl;
        ITreeSelection iTreeSelection = this.getSelection();
        NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO)((TreeSelection)iTreeSelection).getFirstElement();
        if (nodeDefinitionDTO == null) {
            return;
        }
        String string = "Are you sure you want to delete node definition '" + nodeDefinitionDTO.getName() + "'?";
        NodeDefinitionEditor nodeDefinitionEditor = (NodeDefinitionEditor)Utility.getEditor("com.tandbergtv.jpdl.nodedefinitioneditor");
        if (nodeDefinitionEditor != null && nodeDefinitionDTO.getName().equals(nodeDefinitionEditor.getNodeDefinitionDTOName())) {
            string = String.valueOf(string) + " Any changes to the node definition will be lost.";
        }
        if (!(bl = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)string))) {
            return;
        }
        try {
            this.nodeDefinitionService.deleteNodeDefinition(nodeDefinitionDTO.getId(), Utility.getUserName(), false);
        }
        catch (ReferenceDeletionException referenceDeletionException) {
            String string2 = this.buildReferenceDeletionErrorMsg(referenceDeletionException.getReferences());
            boolean bl2 = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Remove References?", (String)string2);
            if (!bl2) {
                return;
            }
            this.nodeDefinitionService.deleteNodeDefinition(nodeDefinitionDTO.getId(), Utility.getUserName(), true);
        }
        catch (ServiceException serviceException) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
        if (nodeDefinitionEditor == null || nodeDefinitionDTO.getName().equals(nodeDefinitionEditor.getNodeDefinitionDTOName())) {
            Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", false);
        }
        this.refresh();
    }

    @Override
    protected void edit() {
        boolean bl;
        ITreeSelection iTreeSelection = this.getSelection();
        Object object = ((TreeSelection)this.getSelection()).getFirstElement();
        if (object instanceof NodeDefinitionDTO && (bl = ((NodeDefinitionDTO)object).getResourceType().isOutOfTheBox())) {
            return;
        }
        this.openNodeDefinition((ISelection)iTreeSelection, true);
        this.refresh();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    @Override
    protected void view() {
        ITreeSelection iTreeSelection = this.getSelection();
        this.openNodeDefinition((ISelection)iTreeSelection, false);
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        this.resourceTypeNodeDefinitions = this.getNodeDefinitionsByResourceType();
        List<ResourceType> list = this.rtService.getViewableResourceTypeList();
        return list;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new NodeDefinitionLabelProvider();
    }

    private void openNodeDefinition(ISelection iSelection, boolean bl) {
        Object object = ((TreeSelection)this.getSelection()).getFirstElement();
        if (object instanceof NodeDefinitionDTO) {
            if (!Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true)) {
                return;
            }
            NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO)((TreeSelection)iSelection).getFirstElement();
            if (nodeDefinitionDTO == null) {
                return;
            }
            NodeDefinitionDTO nodeDefinitionDTO2 = null;
            try {
                if (bl) {
                    if (!this.requestEditConfirmation(nodeDefinitionDTO)) {
                        return;
                    }
                    try {
                        nodeDefinitionDTO2 = this.nodeDefinitionService.getNodeDefinitionForEdit(nodeDefinitionDTO.getId(), Utility.getUserName(), false);
                    }
                    catch (LockFailureException lockFailureException) {
                        ILockable iLockable = lockFailureException.getLockableEntity();
                        String string = iLockable.getLock().getOwnerId();
                        String string2 = this.getUserDisplayMessage(string);
                        boolean bl2 = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Override Lock?", (String)("The node definition " + nodeDefinitionDTO.getName() + " is locked by " + string2 + ", do you wish to override the lock?"));
                        if (!bl2) {
                            return;
                        }
                        nodeDefinitionDTO2 = this.nodeDefinitionService.getNodeDefinitionForEdit(nodeDefinitionDTO.getId(), Utility.getUserName(), true);
                    }
                } else {
                    nodeDefinitionDTO2 = this.nodeDefinitionService.getNodeDefinitionForView(nodeDefinitionDTO.getId());
                }
            }
            catch (ServiceException serviceException) {
                Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
                return;
            }
            IFile iFile = TemplateResourcesUtility.createNodeDefinitionFile(nodeDefinitionDTO2.getXml(), nodeDefinitionDTO2.getGpd());
            try {
                IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IEditorInput)new NonPersistableFileEditorInput(iFile, nodeDefinitionDTO2), (String)"com.tandbergtv.jpdl.nodedefinitioneditor");
            }
            catch (PartInitException partInitException) {
                throw new UIException("Error opening WatchPoint Node Definition Editor.", partInitException);
            }
        }
    }

    private boolean requestEditConfirmation(NodeDefinitionDTO nodeDefinitionDTO) {
        long l = nodeDefinitionDTO.getId();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.nodeDefinitionService.isUsedByNodeDefinition(l);
            bl2 = this.nodeDefinitionService.isUsedByTemplate(l);
        }
        catch (Exception exception) {
            Utility.reportError("Failed to get the Node Definition.", exception);
            return false;
        }
        if (!bl && !bl2) {
            return true;
        }
        String string = System.getProperty(LINE_SEPRATOR);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The Node Definition is being used by existing ");
        if (bl) {
            stringBuilder.append("Node Definition(s)");
        }
        if (bl && bl2) {
            stringBuilder.append(" and ");
        }
        if (bl2) {
            stringBuilder.append("Template(s)");
        }
        stringBuilder.append(".");
        stringBuilder.append(" Changes made to this Node Definition will not be reflected.");
        stringBuilder.append(string);
        stringBuilder.append(string);
        stringBuilder.append("Are you sure you wish to edit this Node Definition?");
        Shell shell = this.getSite().getShell();
        return MessageDialog.openConfirm((Shell)shell, (String)this.getTitle(), (String)stringBuilder.toString());
    }

    private String getUserDisplayMessage(String string) {
        String string2 = null;
        try {
            User user = UserManager.getInstance().getUser(string);
            string2 = String.valueOf(user.getUserName()) + " from machine " + user.getIpAddress();
        }
        catch (UserManagementException userManagementException) {
            logger.error((Object)"Failed to get the User object.", (Throwable)userManagementException);
            string2 = string;
        }
        return string2;
    }

    private void openCreateWizard() {
        IWorkbench iWorkbench = super.getSite().getWorkbenchWindow().getWorkbench();
        NewNodeDefinitionWizard newNodeDefinitionWizard = new NewNodeDefinitionWizard();
        newNodeDefinitionWizard.init(iWorkbench, (IStructuredSelection)new StructuredSelection());
        WizardDialog wizardDialog = new WizardDialog(iWorkbench.getActiveWorkbenchWindow().getShell(), (IWizard)newNodeDefinitionWizard);
        wizardDialog.open();
    }

    private String buildReferenceDeletionErrorMsg(List<IWatchPointDTO> list) {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (IWatchPointDTO iWatchPointDTO : list) {
            if (iWatchPointDTO instanceof NodeDefinitionDTO) {
                hashSet2.add(((NodeDefinitionDTO)iWatchPointDTO).getName());
                continue;
            }
            if (!(iWatchPointDTO instanceof WorkflowTemplateDTO)) continue;
            hashSet.add(((WorkflowTemplateDTO)iWatchPointDTO).getName());
        }
        if (hashSet.size() > 0) {
            string = String.valueOf(string) + "The node definition is being used by the following templates: " + hashSet + "." + System.getProperty(LINE_SEPRATOR);
        }
        if (hashSet2.size() > 0) {
            string = String.valueOf(string) + "The node definition is being used by the following node definitions: " + hashSet2 + "." + System.getProperty(LINE_SEPRATOR);
        }
        string = String.valueOf(string) + "Are you sure you want to delete this node definition?";
        return string;
    }

    @Override
    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        Object object = ((TreeSelection)iSelection).getFirstElement();
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            if (resourceType != null) {
                this.deleteAction.setEnabled(false);
                this.editAction.setEnabled(false);
                this.viewAction.setEnabled(false);
            }
        } else {
            NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO)object;
            if (nodeDefinitionDTO != null) {
                this.deleteAction.setEnabled(!nodeDefinitionDTO.getResourceType().isOutOfTheBox());
                this.editAction.setEnabled(!nodeDefinitionDTO.getResourceType().isOutOfTheBox());
                this.viewAction.setEnabled(true);
            }
        }
    }

    private Map<ResourceType, List<NodeDefinitionDTO>> getNodeDefinitionsByResourceType() {
        List<NodeDefinitionDTO> list = this.nodeDefinitionService.getAllNodeDefinitions();
        HashMap<ResourceType, List<NodeDefinitionDTO>> hashMap = new HashMap<ResourceType, List<NodeDefinitionDTO>>();
        for (NodeDefinitionDTO nodeDefinitionDTO : list) {
            if (nodeDefinitionDTO.getResourceType() == null) continue;
            ResourceType resourceType = nodeDefinitionDTO.getResourceType();
            ArrayList<NodeDefinitionDTO> arrayList = (ArrayList<NodeDefinitionDTO>)hashMap.get(resourceType);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeDefinitionDTO>();
                arrayList.add(nodeDefinitionDTO);
                hashMap.put(resourceType, arrayList);
                continue;
            }
            arrayList.add(nodeDefinitionDTO);
            hashMap.put(resourceType, arrayList);
        }
        return hashMap;
    }

    private class NodeDefinitionContentProvider
    extends DefaultContentProvider {
        private NodeDefinitionContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = null;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                List list = (List)NodeDefinitionExplorer.this.resourceTypeNodeDefinitions.get(resourceType);
                if (list != null) {
                    objectArray = list.toArray();
                }
            } else {
                objectArray = super.getChildren(object);
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            Object object2 = null;
            if (object instanceof NodeDefinitionDTO) {
                NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO)object;
                object2 = nodeDefinitionDTO.getResourceType();
            } else {
                object2 = super.getParent(object);
            }
            return object2;
        }

        public boolean hasChildren(Object object) {
            boolean bl = false;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                List list = (List)NodeDefinitionExplorer.this.resourceTypeNodeDefinitions.get(resourceType);
                bl = list != null && list.size() > 0;
            } else {
                bl = super.hasChildren(object);
            }
            return bl;
        }
    }
}

