/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IInputChangedListener;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IWatchPointEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEvent;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeExportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeWizard;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeExplorer
extends AbstractTreeViewExplorer {
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String INCOMING_MESSAGE_IMAGE_PATH = "message_incoming.png";
    private static final String OUTGOING_MESSAGE_IMAGE_PATH = "message_outgoing.png";
    private ServiceFactory serviceFactory;
    private IResourceTypeService service;
    private ResourceTypeContentProvider contentProvider = new ResourceTypeContentProvider();
    private Action exportAction;

    public ResourceTypeExplorer() {
        this.serviceFactory = ServiceFactory.createFactory();
        this.service = this.serviceFactory.createResourceTypeService();
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.exportAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.createAction);
        Object object = this.getSelectedObject();
        if (object instanceof ResourceType || object instanceof Message) {
            iMenuManager.add((IAction)this.viewAction);
            iMenuManager.add((IAction)this.editAction);
            iMenuManager.add((IAction)this.deleteAction);
            iMenuManager.add((IAction)this.exportAction);
        }
        iMenuManager.add((IAction)this.refreshAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.exportAction = new ViewAction(this, "Export", Utility.getImageDescriptor("export.png")){

            public void performAction() {
                ResourceTypeExplorer.this.export();
            }
        };
    }

    @Override
    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object = this.getSelectedObject();
        if (object == null) {
            return;
        }
        ResourceType resourceType = object instanceof ResourceType ? (ResourceType)object : ((Message)object).getResourceType();
        this.editAction.setEnabled(!resourceType.isOutOfTheBox());
        this.deleteAction.setEnabled(!resourceType.isOutOfTheBox());
        this.exportAction.setEnabled(!resourceType.isOutOfTheBox());
    }

    @Override
    protected void create() {
        Shell shell = this.getSite().getShell();
        ResourceTypeWizard resourceTypeWizard = new ResourceTypeWizard();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)resourceTypeWizard);
        wizardDialog.open();
        if (wizardDialog.getReturnCode() == 0) {
            this.showBusy(true);
            try {
                ResourceType resourceType = resourceTypeWizard.getResourceType();
                this.addResourceTypeToTree(resourceType);
                ResourceTypeEditorInput resourceTypeEditorInput = new ResourceTypeEditorInput(resourceType);
                resourceTypeEditorInput.addInputChangedListener(new ResourceTypeEditorInputChangedListener());
                this.showResourceTypeEditor(resourceTypeEditorInput);
            }
            finally {
                this.showBusy(false);
            }
        }
    }

    @Override
    protected void view() {
        this.openSelectedResourceTypeInEditor(false);
    }

    @Override
    protected void edit() {
        this.openSelectedResourceTypeInEditor(true);
    }

    @Override
    protected void delete() {
        long l;
        ResourceType resourceType = this.getSelectedResourceType();
        long l2 = l = resourceType != null ? resourceType.getId() : -1L;
        if (l == -1L) {
            return;
        }
        if (!this.requestDeleteConfirmation(resourceType)) {
            return;
        }
        this.showBusy(true);
        try {
            if (this.deleteResourceType(l)) {
                this.removeResourceTypeFromTree(resourceType);
                IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
                ResourceType resourceType2 = new ResourceType(l);
                IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)new ResourceTypeEditorInput(resourceType2));
                if (iEditorPart != null) {
                    iWorkbenchPage.closeEditor(iEditorPart, false);
                }
            }
        }
        finally {
            this.showBusy(false);
        }
    }

    protected void export() {
        long l;
        ResourceType resourceType = this.getSelectedResourceType();
        long l2 = l = resourceType != null ? resourceType.getId() : -1L;
        if (l == -1L) {
            return;
        }
        Shell shell = this.getSite().getShell();
        ResourceType resourceType2 = new ResourceType();
        resourceType2.setId(l);
        ResourceTypeExportWizard resourceTypeExportWizard = new ResourceTypeExportWizard(resourceType2);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)resourceTypeExportWizard);
        wizardDialog.open();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openSelectedResourceTypeInEditor(boolean bl) {
        ResourceType resourceType = this.getSelectedResourceType();
        if (resourceType == null) return;
        long l = resourceType.getId();
        long l2 = l;
        if (l2 == -1L) {
            return;
        }
        this.showBusy(true);
        try {
            resourceType = this.getLatestResourceType(l2);
            if (resourceType == null) {
                return;
            }
            if (bl && resourceType.isOutOfTheBox()) {
                MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Error", (String)"The Resource Type is out-of-the-box, cannot edit.");
                return;
            }
            Message message = this.getSelectedMessage();
            ResourceTypeEditorInput resourceTypeEditorInput = null;
            resourceTypeEditorInput = new ResourceTypeEditorInput(resourceType, message, bl);
            resourceTypeEditorInput.addInputChangedListener(new ResourceTypeEditorInputChangedListener());
            this.showResourceTypeEditor(resourceTypeEditorInput);
            return;
        }
        finally {
            this.showBusy(false);
        }
    }

    private boolean requestDeleteConfirmation(ResourceType resourceType) {
        String string = "Are you sure you wish to delete Resource Type: " + resourceType.getName() + "?";
        Shell shell = this.getSite().getShell();
        return MessageDialog.openConfirm((Shell)shell, (String)this.getTitle(), (String)string);
    }

    private IEditorPart showResourceTypeEditor(IEditorInput iEditorInput) {
        IEditorPart iEditorPart = null;
        try {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IEditorInput)iEditorInput, (String)"com.tandbergtv.watchpoint.studio.ui.editor.ResourceTypeEditor", (boolean)true);
        }
        catch (PartInitException partInitException) {
            this.showBusy(false);
            Utility.reportError("Failed to open the Resource Type Editor.", (Exception)((Object)partInitException));
        }
        return iEditorPart;
    }

    private ResourceType getLatestResourceType(long l) {
        ResourceType resourceType = null;
        try {
            resourceType = this.service.getResourceType(l);
        }
        catch (Exception exception) {
            this.showBusy(false);
            Utility.reportError("Failed to get the Resource Type.", exception);
        }
        return resourceType;
    }

    private boolean deleteResourceType(long l) {
        boolean bl = true;
        try {
            this.service.deleteResourceType(l);
        }
        catch (Exception exception) {
            bl = false;
            this.showBusy(false);
            Utility.reportError("Failed to delete the Resource Type.", exception);
        }
        return bl;
    }

    private ResourceType getSelectedResourceType() {
        ResourceType resourceType = null;
        Object object = this.getSelectedObject();
        if (object instanceof ResourceType) {
            resourceType = (ResourceType)object;
        } else if (object instanceof Message) {
            Message message = (Message)object;
            resourceType = message.getResourceType();
        }
        return resourceType;
    }

    private Message getSelectedMessage() {
        Message message = null;
        Object object = this.getSelectedObject();
        if (object instanceof Message) {
            message = (Message)object;
        }
        return message;
    }

    private Object getSelectedObject() {
        Object object = null;
        ITreeSelection iTreeSelection = this.getSelection();
        if (iTreeSelection != null) {
            object = iTreeSelection.getFirstElement();
        }
        return object;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ResourceTypeLabelProvider();
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        List<ResourceType> list = null;
        try {
            list = this.service.getResourceTypeList();
        }
        catch (Exception exception) {
            Utility.reportError("Failed to get the list of Resource Types.", exception);
        }
        return list;
    }

    private void addResourceTypeToTree(ResourceType resourceType) {
        this.contentProvider.addResourceType(resourceType);
        StructuredSelection structuredSelection = new StructuredSelection((Object)resourceType);
        this.getTreeViewer().setSelection((ISelection)structuredSelection, true);
    }

    private void updateResourceTypeInTree(ResourceType resourceType) {
        ITreeSelection iTreeSelection = this.getSelection();
        boolean bl = this.getTreeViewer().getExpandedState((Object)resourceType);
        this.getTreeViewer().getTree().setRedraw(false);
        try {
            this.contentProvider.replaceResourceType(resourceType);
            this.getTreeViewer().setExpandedState((Object)resourceType, bl);
            this.getTreeViewer().setSelection((ISelection)iTreeSelection);
        }
        finally {
            this.getTreeViewer().getTree().setRedraw(true);
        }
    }

    private void removeResourceTypeFromTree(ResourceType resourceType) {
        this.contentProvider.removeResourceType(resourceType);
    }

    private class ResourceTypeContentProvider
    extends DefaultContentProvider {
        private Collection<ResourceType> input = null;

        private ResourceTypeContentProvider() {
        }

        public Object[] getElements(Object object) {
            this.input = (Collection)object;
            List list = (List)object;
            return super.getElements((Object)list);
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = null;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                Set<Message> set = resourceType.getMessages();
                if (set != null) {
                    objectArray = set.toArray();
                }
            } else {
                objectArray = super.getChildren(object);
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            Object object2 = null;
            if (object instanceof Message) {
                Message message = (Message)object;
                object2 = message.getResourceType();
            } else {
                object2 = super.getParent(object);
            }
            return object2;
        }

        public boolean hasChildren(Object object) {
            ResourceType resourceType;
            Set<Message> set;
            boolean bl = false;
            bl = object instanceof ResourceType ? (set = (resourceType = (ResourceType)object).getMessages()) != null && set.size() > 0 : super.hasChildren(object);
            return bl;
        }

        public void addResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            this.input.add(resourceType);
            ResourceTypeExplorer.this.getTreeViewer().add(this.input, (Object)resourceType);
        }

        public void removeResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            if (this.input.contains(resourceType)) {
                this.input.remove(resourceType);
                ResourceTypeExplorer.this.getTreeViewer().remove((Object)resourceType);
            }
        }

        public void replaceResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            if (this.input.contains(resourceType)) {
                this.input.remove(resourceType);
                ResourceTypeExplorer.this.getTreeViewer().remove((Object)resourceType);
            }
            this.input.add(resourceType);
            ResourceTypeExplorer.this.getTreeViewer().add(this.input, (Object)resourceType);
        }
    }

    private class ResourceTypeEditorInputChangedListener
    implements IInputChangedListener {
        private ResourceTypeEditorInputChangedListener() {
        }

        public void inputChanged(InputChangedEvent inputChangedEvent) {
            IWatchPointEditorInput iWatchPointEditorInput = inputChangedEvent.getSource();
            ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput)iWatchPointEditorInput.getAdapter(ResourceTypeEditorInput.class);
            if (resourceTypeEditorInput != null) {
                ResourceType resourceType = resourceTypeEditorInput.getPersistedResourceType();
                ResourceTypeExplorer.this.updateResourceTypeInTree(resourceType);
            }
        }
    }

    private class ResourceTypeLabelProvider
    extends LabelProvider {
        private ResourceTypeLabelProvider() {
        }

        public String getText(Object object) {
            String string = null;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                string = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
            } else if (object instanceof Message) {
                Message message = (Message)object;
                string = message.getName();
                if (!message.isUIDGenerationRequired()) {
                    string = String.valueOf(string) + " [" + message.getUid() + "]";
                }
            } else {
                string = super.getText(object);
            }
            return string;
        }

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof ResourceType) {
                image = this.createImage(ResourceTypeExplorer.RESOURCE_TYPE_IMAGE_PATH);
                String string = ResourceTypeExplorer.RESOURCE_TYPE_IMAGE_PATH;
                if (string != null) {
                    ImageDescriptor imageDescriptor = Utility.getImageDescriptor(string);
                    image = new Image((Device)Display.getCurrent(), imageDescriptor.getImageData());
                }
            } else if (object instanceof Message) {
                Message message = (Message)object;
                String string = message.isIncoming() ? ResourceTypeExplorer.INCOMING_MESSAGE_IMAGE_PATH : ResourceTypeExplorer.OUTGOING_MESSAGE_IMAGE_PATH;
                image = this.createImage(string);
            } else {
                image = super.getImage(object);
            }
            return image;
        }

        private Image createImage(String string) {
            if (string == null) {
                return null;
            }
            ImageDescriptor imageDescriptor = Utility.getImageDescriptor(string);
            return new Image((Device)Display.getCurrent(), imageDescriptor.getImageData());
        }
    }
}

