/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportSelectDirPage
extends WizardPage {
    private static final String EMPTY_STRING = "";
    private String labelText;
    private Text dirText;
    private Button deleteCheckButton;

    public ExportSelectDirPage(String string) {
        super(string);
        this.setLabel(EMPTY_STRING);
    }

    public void setLabel(String string) {
        this.labelText = string != null ? string : EMPTY_STRING;
    }

    public String getLabel() {
        return this.labelText;
    }

    public String getSelectedDir() {
        return this.dirText.getText();
    }

    public boolean isDeleteContents() {
        return this.deleteCheckButton.isEnabled() && this.deleteCheckButton.getSelection();
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.getSelectedDir().length() > 0;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createDirSelectionControl(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createDirSelectionControl(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.labelText);
        this.dirText = new Text(composite, 2048);
        this.dirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExportSelectDirPage.this.validate();
            }
        });
        Button button = null;
        button = new Button(composite, 8);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ExportSelectDirPage.this.getDirPathFormUser();
                if (string != null) {
                    ExportSelectDirPage.this.dirText.setText(string);
                }
            }
        });
        this.deleteCheckButton = new Button(composite, 32);
        this.deleteCheckButton.setText("Delete contents");
        this.deleteCheckButton.setEnabled(false);
        this.deleteCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportSelectDirPage.this.validate();
            }
        });
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        label.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)label, 10);
        formData2.right = new FormAttachment((Control)button, -10);
        this.dirText.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment(100, -10);
        button.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.dirText, 10);
        formData4.left = new FormAttachment((Control)label, 10);
        this.deleteCheckButton.setLayoutData((Object)formData4);
    }

    private void validate() {
        if (this.dirText.getText().trim().length() < this.dirText.getText().length()) {
            this.setErrorMessage("Folder entry cannot start or end with spaces");
        } else {
            File file = new File(this.dirText.getText());
            if (file.exists()) {
                if (file.isDirectory()) {
                    String[] stringArray = file.list();
                    if (stringArray == null || stringArray.length == 0) {
                        this.deleteCheckButton.setSelection(false);
                        this.deleteCheckButton.setEnabled(false);
                        this.setErrorMessage(null);
                    } else {
                        this.deleteCheckButton.setEnabled(true);
                        if (!this.deleteCheckButton.getSelection()) {
                            this.setErrorMessage("Selected Folder is not empty");
                        } else {
                            this.setErrorMessage(null);
                        }
                    }
                } else {
                    this.setErrorMessage("Specified entry is not a folder");
                }
            } else {
                this.setErrorMessage("Specified Folder does not exist");
            }
        }
        this.getContainer().updateButtons();
    }

    private String getDirPathFormUser() {
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 131072);
        directoryDialog.setText("Select Folder");
        return directoryDialog.open();
    }
}

