/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MessageWizardPage
extends WizardPage {
    private Text nameText;
    private Text uidManualEntryText;
    private Text descriptionText;
    private Group uidGroup;
    private Group typeGroup;
    private Button uidAutoGenerateButton;
    private Button uidManualEntryButton;
    private Button typeIncomingButton;
    private Button typeOutgoingButton;
    private ModifyListener validationListener;

    public MessageWizardPage() {
        super("Message");
        this.setTitle("Create Message");
        this.setDescription("Create a new Message");
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MessageWizardPage.this.validate();
            }
        };
    }

    public String getMessageName() {
        return this.convertEmptyToNull(this.nameText.getText());
    }

    public Message getMessageObject() {
        Message message = new Message();
        message.setName(this.convertEmptyToNull(this.nameText.getText()));
        message.setUIDGenerationRequired(this.uidAutoGenerateButton.getSelection());
        message.setUid(this.convertEmptyToNull(this.uidManualEntryText.getText()));
        message.setIncoming(this.typeIncomingButton.getSelection());
        message.setProtocol(null);
        message.setDescription(this.convertEmptyToNull(this.descriptionText.getText()));
        return message;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createCustomControls(composite2);
        this.setValuesAndState();
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createCustomControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Name : ");
        this.nameText = new Text(composite, 2048);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
        Label label2 = new Label(composite, 0);
        label2.setText("UID : ");
        this.uidGroup = new Group(composite, 0);
        this.uidAutoGenerateButton = new Button((Composite)this.uidGroup, 16);
        this.uidAutoGenerateButton.setText("Auto Generate");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageWizardPage.this.uidManualEntryText.setEnabled(MessageWizardPage.this.uidManualEntryButton.getSelection());
                if (!MessageWizardPage.this.uidManualEntryButton.getSelection()) {
                    MessageWizardPage.this.uidManualEntryText.setText("");
                }
                MessageWizardPage.this.validate();
            }
        };
        this.uidAutoGenerateButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.uidManualEntryButton = new Button((Composite)this.uidGroup, 16);
        this.uidManualEntryButton.setText("Manual Entry");
        this.uidManualEntryButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.uidManualEntryText = new Text((Composite)this.uidGroup, 2048);
        this.uidManualEntryText.setTextLimit(10);
        this.uidManualEntryText.addModifyListener(this.validationListener);
        Label label3 = new Label(composite, 0);
        label3.setText("Type : ");
        this.typeGroup = new Group(composite, 0);
        this.typeIncomingButton = new Button((Composite)this.typeGroup, 16);
        this.typeIncomingButton.setText("Incoming");
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageWizardPage.this.validate();
            }
        };
        this.typeIncomingButton.addSelectionListener((SelectionListener)selectionAdapter2);
        this.typeOutgoingButton = new Button((Composite)this.typeGroup, 16);
        this.typeOutgoingButton.setText("Outgoing");
        this.typeOutgoingButton.addSelectionListener((SelectionListener)selectionAdapter2);
        Label label4 = new Label(composite, 0);
        label4.setText("Description : ");
        this.descriptionText = new Text(composite, 2818);
        this.descriptionText.setTextLimit(256);
        this.descriptionText.addModifyListener(this.validationListener);
        FormData formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(100, -10);
        this.nameText.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.nameText, 10);
        label2.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(30, 2);
        formData3.right = new FormAttachment(100, -10);
        formData3.top = new FormAttachment((Control)this.nameText, 10);
        this.uidGroup.setLayoutData((Object)formData3);
        this.uidGroup.setLayout((Layout)new FormLayout());
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.uidAutoGenerateButton, 10);
        this.uidManualEntryButton.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment((Control)this.uidAutoGenerateButton, 10);
        formData5.left = new FormAttachment((Control)this.uidManualEntryButton, 10);
        formData5.right = new FormAttachment(100, -5);
        this.uidManualEntryText.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)this.uidGroup, 10);
        label3.setLayoutData((Object)formData6);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment(30, 2);
        formData7.right = new FormAttachment(100, -10);
        formData7.top = new FormAttachment((Control)this.uidGroup, 10);
        this.typeGroup.setLayoutData((Object)formData7);
        this.typeGroup.setLayout((Layout)new FormLayout());
        FormData formData8 = new FormData();
        formData8.left = new FormAttachment((Control)this.typeIncomingButton, 10);
        this.typeOutgoingButton.setLayoutData((Object)formData8);
        FormData formData9 = new FormData();
        formData9.height = 70;
        formData9.top = new FormAttachment((Control)this.typeGroup, 10);
        label4.setLayoutData((Object)formData9);
        FormData formData10 = new FormData();
        formData10.top = new FormAttachment((Control)this.typeGroup, 10);
        formData10.left = new FormAttachment(30, 2);
        formData10.right = new FormAttachment(100, -10);
        formData10.bottom = new FormAttachment(100, -10);
        this.descriptionText.setLayoutData((Object)formData10);
    }

    private void setValuesAndState() {
        this.uidAutoGenerateButton.setSelection(true);
        this.uidManualEntryText.setEnabled(false);
        this.typeOutgoingButton.setSelection(true);
    }

    private void validate() {
        String string = null;
        string = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        if (this.uidManualEntryButton.getSelection() && (string = UIValidator.validateValue("UID", this.uidManualEntryText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED)) != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("Description", this.descriptionText.getText(), UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String string) {
        this.setErrorMessage(string);
        this.getContainer().updateButtons();
    }

    private String convertEmptyToNull(String string) {
        return string.length() == 0 ? null : string;
    }
}

