/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewNodeDefinitionWizardPage
extends WizardPage {
    private Text nameText;
    private Combo typeCombo;
    private Combo resourceTypeCombo;
    private ResourceType[] resourceTypeArray = null;

    protected NewNodeDefinitionWizardPage() {
        super("Node Definition");
        this.setTitle("Create Node Definition");
        this.setDescription("Create a new Node Definition");
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createNameText(composite2);
        this.createTypeCombo(composite2);
        this.createResourceTypeCombo(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public String getNodeDefinitionName() {
        return this.nameText.getText();
    }

    public String getType() {
        return this.typeCombo.getText();
    }

    public ResourceType getResourceType() {
        return this.resourceTypeArray[this.resourceTypeCombo.getSelectionIndex()];
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createNameText(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Name : ");
        this.nameText = new Text(composite, 2048);
        this.nameText.setTextLimit(50);
        FormData formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(90, 0);
        this.nameText.setLayoutData((Object)formData);
        this.nameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                this.checkNodeDefinitionName();
                NewNodeDefinitionWizardPage.this.getContainer().updateButtons();
            }

            private void checkNodeDefinitionName() {
                String string = null;
                if (NewNodeDefinitionWizardPage.this.nameText.getText().equals("")) {
                    string = "Node Definition name can not be empty.";
                } else if (NewNodeDefinitionWizardPage.this.nameText.getText().startsWith(" ") || NewNodeDefinitionWizardPage.this.nameText.getText().endsWith(" ")) {
                    string = "Node Definition name is not valid. A Node Definition name must not start or end with a blank.";
                }
                if (string != null) {
                    NewNodeDefinitionWizardPage.this.setErrorMessage(string);
                } else {
                    NewNodeDefinitionWizardPage.this.setErrorMessage(null);
                }
            }
        });
    }

    private void createTypeCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Type : ");
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.nameText, 10);
        label.setLayoutData((Object)formData);
        this.typeCombo = new Combo(composite, 780);
        formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(90, 0);
        formData.top = new FormAttachment((Control)this.nameText, 10);
        this.typeCombo.setLayoutData((Object)formData);
        this.fillTypeCombo();
    }

    private void createResourceTypeCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Resource Type : ");
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.typeCombo, 10);
        label.setLayoutData((Object)formData);
        this.resourceTypeCombo = new Combo(composite, 780);
        formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(90, 0);
        formData.top = new FormAttachment((Control)this.typeCombo, 10);
        this.resourceTypeCombo.setLayoutData((Object)formData);
        this.fillResourceTypeCombo();
    }

    private void fillTypeCombo() {
        this.typeCombo.add(NodeDefinitionType.SingleNode.toString());
        this.typeCombo.add(NodeDefinitionType.SuperState.toString());
        this.typeCombo.select(0);
    }

    private void fillResourceTypeCombo() {
        this.resourceTypeCombo.removeAll();
        List<ResourceType> list = ServiceFactory.createFactory().createResourceTypeService().getViewableNonOOBResourceTypeList();
        this.resourceTypeArray = new ResourceType[list.size()];
        this.resourceTypeArray = list.toArray(this.resourceTypeArray);
        Arrays.sort(this.resourceTypeArray, new Comparator<ResourceType>(){

            @Override
            public int compare(ResourceType resourceType, ResourceType resourceType2) {
                return resourceType.getName().compareTo(resourceType2.getName());
            }
        });
        ResourceType[] resourceTypeArray = this.resourceTypeArray;
        int n = this.resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType resourceType = resourceTypeArray[n2];
            this.resourceTypeCombo.add(resourceType.getName());
            ++n2;
        }
        if (this.resourceTypeCombo.getItemCount() > 0) {
            this.resourceTypeCombo.select(0);
        }
    }
}

