/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.usermgmt;

import com.tandbergtv.watchpoint.studio.usermgmt.DefaultUserIdGenerator;
import com.tandbergtv.watchpoint.studio.usermgmt.IUserIdGenerator;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Logger;

public class UserManager {
    private static final Logger logger = Logger.getLogger(UserManager.class);
    private static UserManager instance;
    private User currentUser = this.createUser();
    private IUserIdGenerator idGenerator = new DefaultUserIdGenerator();

    private UserManager() {
    }

    public static UserManager getInstance() {
        if (instance == null) {
            instance = new UserManager();
        }
        return instance;
    }

    private User createUser() {
        String string = System.getProperty("user.name");
        InetAddress inetAddress = null;
        String string2 = "";
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)("Unable to get the IP Address:  " + unknownHostException.getMessage()));
        }
        User user = new User(string, string2, System.currentTimeMillis(), new Random().nextInt());
        return user;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public String getCurrentUserId() throws UserManagementException {
        return this.idGenerator.generateUserId(this.currentUser);
    }

    public String getUserId(User user) throws UserManagementException {
        return this.idGenerator.generateUserId(user);
    }

    public User getUser(String string) throws UserManagementException {
        return this.idGenerator.generateUser(string);
    }
}

