/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.ui.model.WPTransition;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ConditionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.model.DecisionExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionExprValidationUtil {
    private static final String[] REGULAR_EXPRESSION = new String[]{"[(][\\s]*[)]", "[[a-z][A-Z][0-9]'][\\s]*[=|&][\\s]*[['[A-Z][a-z]][0-9]]", "[|&][\\s]*[')]", "[(][\\s]*[|&]", "[)][\\s]*[(]", "[=][\\s]*[)]", "[)][\\s]*[[a-z][A-Z][0-9]]", "[|][\\s]*[&]", "[&][\\s]*[|]", "[|&][\\s]*[=]", "[=][\\s]*[|&]", "[|][\\s]*[|][\\s]*[|]", "[&][\\s]*[&][\\s]*[&]", "[=][\\s]*[=][\\s]*[=]", "[\\w][\\s]*'[\\s]*[\\w]", "[\\w][\\s]*![\\s]*[\\w]", "[&][!]", "[!][\\s]", "[|][!]", "[!][|]", "[&][!]", "[!][&]", "[&][\\s]+[&]", "[(!][)]"};
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'+', '-', '*', '/', '?'};
    private static final String PREFIX = "(";
    private static final String SUFFIX = ")";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_QUOTE = "'";

    public static ValidationMessage validateDecisonExpr(DecisionExpression decisionExpression) {
        ValidationMessage validationMessage = null;
        Decision decision = decisionExpression.getDecision();
        String string = decision.getExpression();
        if (string != null && !EMPTY_STRING.equals(string)) {
            validationMessage = DecisionExprValidationUtil.isDecisionExprValid(string, decisionExpression);
        }
        return validationMessage;
    }

    public static ValidationMessage validateConditionExpr(ConditionExpression conditionExpression) {
        String string;
        ValidationMessage validationMessage = null;
        Transition transition = conditionExpression.getTransition();
        Condition condition = transition.getCondition();
        String string2 = string = condition != null ? condition.getExpression() : null;
        if (string != null && !EMPTY_STRING.equals(string)) {
            validationMessage = DecisionExprValidationUtil.isConditionExprValid(string, conditionExpression);
        }
        return validationMessage;
    }

    public static Map<Integer, String> getOperands(String string) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        char[] cArray = new char[]{'=', '|', '!', '&', '(', ')', '>', '<', '#', '{', ' ', '?', ':'};
        int n = 0;
        int n2 = 0;
        String string2 = EMPTY_STRING;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            boolean bl = true;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (c == cArray[n3]) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                string2 = String.valueOf(string2) + c;
            }
            if (!string2.equals(EMPTY_STRING) && !bl) {
                if (string2.indexOf(39) == -1 && !DecisionExprValidationUtil.isConstant(string2)) {
                    hashMap.put(n, string2);
                }
                string2 = EMPTY_STRING;
            }
            if (!bl) {
                n = n2 + 1;
            }
            ++n2;
        }
        return hashMap;
    }

    private static ValidationMessage isConditionExprValid(String string, ConditionExpression conditionExpression) {
        ValidationMessage validationMessage = null;
        Transition transition = conditionExpression.getTransition();
        validationMessage = DecisionExprValidationUtil.isExpressionValid(string, conditionExpression.getContainerVariables(), transition);
        return validationMessage;
    }

    private static ValidationMessage isDecisionExprValid(String string, DecisionExpression decisionExpression) {
        Decision decision = decisionExpression.getDecision();
        ValidationMessage validationMessage = null;
        String[] stringArray = string.split("\\?");
        if (stringArray.length != 2) {
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_DECISION_EXPRESSION);
            return validationMessage;
        }
        validationMessage = DecisionExprValidationUtil.isExpressionValid(stringArray[0], decisionExpression.getContainerVariables(), decision);
        if (validationMessage != null) {
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.isValidTransitionState(stringArray[1])) {
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_NUMBER_OF_VARIABLES);
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.isValidTransitionExpression(stringArray[1])) {
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_QUOTES);
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.isValidTransExprQuotes(stringArray[1])) {
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_EXTRA_QUOTES);
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.isTransVariableEmpty(stringArray[1])) {
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.TRANSITION_VARIABLE_EMPTY);
            return validationMessage;
        }
        String string2 = DecisionExprValidationUtil.getInvalidTransitionVariables(stringArray[1], decisionExpression);
        if (string2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            validationMessage = new ValidationMessage(decision, ValidationMessageType.Error, ValidationMessageCode.INVALID_TRANSITION_VARIABLES, arrayList);
            return validationMessage;
        }
        return validationMessage;
    }

    private static ValidationMessage isExpressionValid(String string, List<ContainerVariable> list, Object object) {
        ValidationMessage validationMessage = null;
        if (!(string = string.trim()).startsWith(PREFIX) || !string.endsWith(SUFFIX)) {
            validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_OPEN_CLOSE_PARENTHESIS);
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.checkBrackets(string)) {
            validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_BRACKETS);
            return validationMessage;
        }
        if (!DecisionExprValidationUtil.checkQuotes(string)) {
            validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_QUOTES);
            return validationMessage;
        }
        if (DecisionExprValidationUtil.checkExpr(string)) {
            if (object instanceof Decision) {
                validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_DECISION_EXPRESSION);
            } else if (object instanceof WPTransition) {
                validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_CONDITION_EXPRESSION);
            }
            return validationMessage;
        }
        if (DecisionExprValidationUtil.checkIllegalCharacters(string)) {
            validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.ILLEGAL_CHARACTERS);
            return validationMessage;
        }
        String string2 = DecisionExprValidationUtil.getInvalidVariables(DecisionExprValidationUtil.getLogicalOperands(string), list);
        if (string2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            validationMessage = new ValidationMessage(object, ValidationMessageType.Error, ValidationMessageCode.INVALID_VARIABLES, arrayList);
            return validationMessage;
        }
        return validationMessage;
    }

    private static boolean checkBrackets(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '(' && n2 >= 0) {
                ++n2;
            } else if (string.charAt(n3) == ')') {
                --n2;
            }
            ++n3;
        }
        return n2 == 0;
    }

    private static boolean checkQuotes(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '\'') {
                ++n2;
            }
            ++n3;
        }
        return n2 % 2 == 0;
    }

    private static boolean checkExpr(String string) {
        String[] stringArray = REGULAR_EXPRESSION;
        int n = REGULAR_EXPRESSION.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] getLogicalOperands(String string) {
        char[] cArray = new char[]{'=', '|', '!', '&', '(', ')', '>', '<'};
        int n = 0;
        int n2 = string.length();
        String string2 = EMPTY_STRING;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < n2) {
            char c = string.charAt(n);
            boolean bl = true;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (c == cArray[n3]) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                stringBuffer.append(string.charAt(n));
                string2 = stringBuffer.toString().replaceAll(SPACE, EMPTY_STRING);
            }
            if (!string2.equals(EMPTY_STRING) && !bl || n == n2 - 1 && bl) {
                if (string2.indexOf(SINGLE_QUOTE) == -1 && !DecisionExprValidationUtil.isConstant(string2)) {
                    arrayList.add(stringBuffer.toString().trim());
                }
                stringBuffer.delete(0, stringBuffer.length());
                string2 = EMPTY_STRING;
            }
            ++n;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private static boolean checkIllegalCharacters(String string) {
        boolean bl = false;
        String[] stringArray = DecisionExprValidationUtil.getLogicalOperands(string);
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = stringArray2[n2];
                stringBuffer.append(string2.trim());
                ++n2;
            }
            string2 = stringBuffer.toString();
            n2 = 0;
            while (n2 < ILLEGAL_CHARACTERS.length) {
                n = string2.indexOf(ILLEGAL_CHARACTERS[n2]);
                if (n != -1) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private static String getInvalidVariables(String[] stringArray, List<ContainerVariable> list) {
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            bl = false;
            for (ContainerVariable containerVariable : list) {
                if (!string.trim().equals(containerVariable.getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                hashSet.add(string.trim());
            }
            ++n2;
        }
        return DecisionExprValidationUtil.buildCSVString(hashSet);
    }

    private static boolean isValidTransitionState(String string) {
        String[] stringArray = string.split(":");
        return stringArray.length == 2;
    }

    private static String getInvalidTransitionVariables(String string, DecisionExpression decisionExpression) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        List<Transition> list = DecisionExprValidationUtil.getTransitionVariables(decisionExpression.getDecision());
        string = string.replaceAll(SINGLE_QUOTE, EMPTY_STRING);
        String[] stringArray2 = stringArray = string.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            bl = false;
            for (Transition transition : list) {
                if (!string2.trim().equals(transition.getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                hashSet.add(string2.trim());
            }
            ++n2;
        }
        return DecisionExprValidationUtil.buildCSVString(hashSet);
    }

    private static String buildCSVString(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : collection) {
            stringBuilder.append(bl ? EMPTY_STRING : ", ");
            bl = false;
            stringBuilder.append(string);
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private static List<Transition> getTransitionVariables(Decision decision) {
        Transition[] transitionArray;
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        Transition[] transitionArray2 = transitionArray = decision.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray2[n2];
            arrayList.add(transition);
            ++n2;
        }
        return arrayList;
    }

    private static int checkQuoteCount(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '\'') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private static boolean isValidTransitionExpression(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!string2.trim().startsWith(SINGLE_QUOTE) || !string2.trim().endsWith(SINGLE_QUOTE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isTransVariableEmpty(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals("''")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidTransExprQuotes(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (DecisionExprValidationUtil.checkQuoteCount(string2) != 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isConstant(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '9' || c < '0') {
                return false;
            }
            ++n;
        }
        return true;
    }
}

