/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public final class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class);
    private static final long COPY_BUF_MAX_SIZE = 67076096L;

    private FileUtil() {
    }

    public static boolean deleteFolderContents(File file, boolean bl) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        boolean bl2 = true;
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory() && bl) {
                    bl2 &= FileUtil.deleteFolderContents(fileArray[n], bl);
                    bl2 &= fileArray[n].delete();
                } else {
                    bl2 &= fileArray[n].delete();
                }
                ++n;
            }
        }
        return bl2;
    }

    public static boolean copyFileOrFolder(File file, File file2, boolean bl) {
        boolean bl2;
        block7: {
            block8: {
                bl2 = true;
                if (!file.isDirectory()) break block8;
                if (file2.exists() && !file2.isDirectory()) {
                    String string = "The target location is an existing file, failed to copy folder: " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath();
                    logger.warn((Object)string);
                    return false;
                }
                if (!file2.exists() && !file2.mkdirs()) {
                    String string = "Failed to create folder: " + file2.getAbsolutePath() + " when attempting to copy folder: " + file.getAbsolutePath();
                    logger.warn((Object)string);
                    return false;
                }
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block7;
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file3;
                    File file4 = fileArray2[n2];
                    if (!(file4.isDirectory() && !bl || FileUtil.copyFileOrFolder(file4, file3 = new File(file2, file4.getName()), bl))) {
                        bl2 = false;
                        break block7;
                    }
                    ++n2;
                }
                break block7;
            }
            if (file2.exists()) {
                String string = "The target location already exists, failed to copy file: " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath();
                logger.warn((Object)string);
                return false;
            }
            try {
                FileUtil.copyFile(file, file2);
            }
            catch (IOException iOException) {
                String string = "Failed when copying file from: " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath();
                logger.warn((Object)string, (Throwable)iOException);
                bl2 = false;
            }
        }
        return bl2;
    }

    private static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel = fileInputStream.getChannel();
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            long l = fileChannel.size();
            long l2 = 0L;
            while (l2 < l) {
                l2 += fileChannel.transferTo(l2, 67076096L, fileChannel2);
            }
        }
        finally {
            FileUtil.closeStream(fileInputStream, file.getAbsolutePath());
            FileUtil.closeStream(fileOutputStream, file2.getAbsolutePath());
        }
    }

    private static void closeStream(Closeable closeable, String string) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            logger.warn((Object)("Failed to close the file stream for file: " + string + ", ignoring error."), (Throwable)iOException);
        }
    }
}

