/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerExprValidator {
    private static final String REGEX_SHORT_DURATION = "[0-23][0-23]:\\d\\d:\\d\\d";
    private static final String REGEX_LONG_DURATION = "\\d\\dT[0-23][0-23]:\\d\\d:\\d\\d";
    private List<ContainerVariable> variables;

    protected TimerExprValidator(List<ContainerVariable> arrayList) {
        this.variables = arrayList != null ? arrayList : new ArrayList();
    }

    protected ValidationMessage validate(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return this.validate(TimerExpressionMarshaller.unmarshall(string));
    }

    protected ValidationMessage validate(TimerExpression timerExpression) {
        if (timerExpression == null) {
            return null;
        }
        if (timerExpression.getOperator() == null) {
            if (timerExpression.getOperand2() != null) {
                return this.getGenericInvalidTimerExprVM();
            }
            return this.validateUnaryExpression(timerExpression.getOperand1());
        }
        if (timerExpression.getOperator().equals("+")) {
            return this.validateAdditionExpression(timerExpression.getOperand1(), timerExpression.getOperand2());
        }
        if (timerExpression.getOperator().equals("*")) {
            return this.validateMultiplicationExpression(timerExpression.getOperand1(), timerExpression.getOperand2());
        }
        return null;
    }

    protected abstract ValidationMessage getInvalidAdditionExprVM();

    protected abstract ValidationMessage getInvalidMultiplicationExprVM();

    protected abstract ValidationMessage getInvalidUnaryExprVM();

    protected abstract ValidationMessage getGenericInvalidTimerExprVM();

    private ValidationMessage validateAdditionExpression(String string, String string2) {
        if (!this.isValidShortDuration(string) || !this.isValidShortDuration(string2)) {
            return this.getInvalidAdditionExprVM();
        }
        return null;
    }

    private ValidationMessage validateMultiplicationExpression(String string, String string2) {
        if (!this.isValidShortDuration(string) || !this.isValidMultiplier(string2)) {
            return this.getInvalidMultiplicationExprVM();
        }
        return null;
    }

    private ValidationMessage validateUnaryExpression(String string) {
        if (!this.isValidShortDuration(string) && !this.isLongDurationConstant(string)) {
            return this.getInvalidUnaryExprVM();
        }
        return null;
    }

    private boolean isValidShortDuration(String string) {
        return this.isShortDurationConstant(string) || this.isVariableOfTypeDuration(string);
    }

    private boolean isShortDurationConstant(String string) {
        return Pattern.matches(REGEX_SHORT_DURATION, string);
    }

    private boolean isVariableOfTypeDuration(String string) {
        for (ContainerVariable containerVariable : this.variables) {
            if (containerVariable.getName() == null || !containerVariable.getName().equals(string)) continue;
            return containerVariable.getType() != null && containerVariable.getType().equals("DURATION");
        }
        return false;
    }

    private boolean isValidMultiplier(String string) {
        return this.isValidMultiplicativeConstant(string) || this.isVariableOfTypeStringOrInt(string);
    }

    private boolean isValidMultiplicativeConstant(String string) {
        try {
            return Double.parseDouble(string) > 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isVariableOfTypeStringOrInt(String string) {
        for (ContainerVariable containerVariable : this.variables) {
            if (containerVariable.getName() == null || !containerVariable.getName().equals(string)) continue;
            return containerVariable.getType() != null && (containerVariable.getType().equals("STRING") || containerVariable.getType().equals("INT"));
        }
        return false;
    }

    private boolean isLongDurationConstant(String string) {
        return Pattern.matches(REGEX_LONG_DURATION, string);
    }
}

