/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPEndState;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedNodeDefinitionNodeTypesRule
extends AllowedNodeTypesRule<NodeDefinitionGraph> {
    @Override
    protected List<Class<? extends NodeElement>> getAllowedNodeTypes() {
        ArrayList<Class<? extends NodeElement>> arrayList = new ArrayList<Class<? extends NodeElement>>();
        arrayList.add(WPEndState.class);
        arrayList.add(Decision.class);
        arrayList.add(NodeDefinition.class);
        arrayList.add(AutomaticTaskNode.class);
        return arrayList;
    }

    @Override
    protected void validateNodeType(NodeElement nodeElement, List<ValidationMessage> list) {
        super.validateNodeType(nodeElement, list);
        if (nodeElement instanceof NodeDefinition && ((NodeDefinition)nodeElement).getNodeType() != NodeDefinitionType.SingleNode) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_NODE_TYPE;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

