/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationAbsentRule
implements IValidationRule<IDurationElement> {
    @Override
    public List<ValidationMessage> validateRule(IDurationElement iDurationElement) {
        ValidationMessageCode validationMessageCode;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (this.isNotBlank(iDurationElement.getDuration())) {
            validationMessageCode = ValidationMessageCode.NODE_DURATION_DEFINED;
            arrayList.add(new ValidationMessage(iDurationElement, ValidationMessageType.Error, validationMessageCode));
        }
        if (this.isNotBlank(iDurationElement.getTaskDuration())) {
            validationMessageCode = ValidationMessageCode.NODE_TASKDURATION_DEFINED;
            arrayList.add(new ValidationMessage(iDurationElement, ValidationMessageType.Error, validationMessageCode));
        }
        return arrayList;
    }

    private boolean isNotBlank(String string) {
        return string != null && string.trim().length() > 0;
    }
}

