/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeVariablesRule<NE extends NodeElement>
implements IValidationRule<NE> {
    private static final String NAME_REGEX = "^.+$";
    private static final String MAPPED_NAME_REGEX = "^.+$";
    private static final String TYPE_REGEX = "^.+$";
    private static final Pattern NAME_PATTERN = Pattern.compile("^.+$");
    private static final Pattern MAPPED_NAME_PATTERN = Pattern.compile("^.+$");
    private static final Pattern TYPE_PATTERN = Pattern.compile("^.+$");

    @Override
    public List<ValidationMessage> validateRule(NE NE) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        List<Variable> list = this.getVariables(NE);
        if (list != null) {
            this.validateVariables(NE, list, arrayList);
            for (Variable variable : list) {
                this.validateVariableProperties(NE, variable, arrayList);
            }
        }
        return arrayList;
    }

    protected abstract List<Variable> getVariables(NE var1);

    protected void validateVariables(NE NE, List<Variable> list, List<ValidationMessage> list2) {
        this.validateBlankNames(NE, list, list2);
        this.validateBlankMappedNames(NE, list, list2);
    }

    protected void validateVariableProperties(NE NE, Variable variable, List<ValidationMessage> list) {
        this.validateNameBlank(NE, variable, list);
        this.validateNameValue(NE, variable, list);
        this.validateMappedNameBlank(NE, variable, list);
        this.validateMappedNameValue(NE, variable, list);
        this.validateTypeBlank(NE, variable, list);
        this.validateTypeValue(NE, variable, list);
    }

    protected void validateBlankNames(NE NE, List<Variable> list, List<ValidationMessage> list2) {
        if (!this.isValidatingBlankNames(NE)) {
            return;
        }
        if (list != null) {
            boolean bl = false;
            for (Object object : list) {
                String string = object.getName();
                if (!this.isBlank(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                Object object;
                object = this.getBlankNamesCode(NE);
                list2.add(new ValidationMessage(NE, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
            }
        }
    }

    protected void validateBlankMappedNames(NE NE, List<Variable> list, List<ValidationMessage> list2) {
        if (!this.isValidatingBlankMappedNames(NE)) {
            return;
        }
        if (list != null) {
            boolean bl = false;
            for (Object object : list) {
                String string = object.getMappedName();
                if (!this.isBlank(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                Object object;
                object = this.getBlankMappedNamesCode(NE);
                list2.add(new ValidationMessage(NE, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
            }
        }
    }

    protected void validateNameBlank(NE NE, Variable variable, List<ValidationMessage> list) {
        if (!this.isValidatingNameBlank(NE)) {
            return;
        }
        if (this.isBlank(variable.getName())) {
            ValidationMessageCode validationMessageCode = this.getNameBlankCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected void validateNameValue(NE NE, Variable variable, List<ValidationMessage> list) {
        if (!this.isValidatingNameValue(NE)) {
            return;
        }
        String string = variable.getName();
        if (!this.isBlank(string) && !this.matchesPattern(NAME_PATTERN, string)) {
            ValidationMessageCode validationMessageCode = this.getNameInvalidCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected void validateMappedNameBlank(NE NE, Variable variable, List<ValidationMessage> list) {
        if (!this.isValidatingMappedNameBlank(NE)) {
            return;
        }
        if (this.isBlank(variable.getMappedName())) {
            ValidationMessageCode validationMessageCode = this.getMappedNameBlankCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected void validateMappedNameValue(NE NE, Variable variable, List<ValidationMessage> list) {
        if (!this.isValidatingMappedNameValue(NE)) {
            return;
        }
        String string = variable.getMappedName();
        if (!this.isBlank(string) && !this.matchesPattern(MAPPED_NAME_PATTERN, string)) {
            ValidationMessageCode validationMessageCode = this.getMappedNameInvalidCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected void validateTypeBlank(NE NE, Variable variable, List<ValidationMessage> list) {
        String string;
        if (!this.isValidatingTypeBlank(NE)) {
            return;
        }
        String string2 = string = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
        if (this.isBlank(string)) {
            ValidationMessageCode validationMessageCode = this.getTypeBlankCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected void validateTypeValue(NE NE, Variable variable, List<ValidationMessage> list) {
        String string;
        if (!this.isValidatingTypeValue(NE)) {
            return;
        }
        String string2 = string = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
        if (!this.isBlank(string) && !this.matchesPattern(TYPE_PATTERN, string)) {
            ValidationMessageCode validationMessageCode = this.getTypeInvalidCode(NE);
            List<String> list2 = this.generateParameters(NE, variable);
            list.add(new ValidationMessage(NE, ValidationMessageType.Error, validationMessageCode, list2));
        }
    }

    protected boolean isValidatingBlankNames(NE NE) {
        return true;
    }

    protected boolean isValidatingBlankMappedNames(NE NE) {
        return true;
    }

    protected boolean isValidatingNameBlank(NE NE) {
        return true;
    }

    protected boolean isValidatingNameValue(NE NE) {
        return true;
    }

    protected boolean isValidatingMappedNameBlank(NE NE) {
        return true;
    }

    protected boolean isValidatingMappedNameValue(NE NE) {
        return true;
    }

    protected boolean isValidatingTypeBlank(NE NE) {
        return true;
    }

    protected boolean isValidatingTypeValue(NE NE) {
        return true;
    }

    protected ValidationMessageCode getBlankNamesCode(NE NE) {
        return ValidationMessageCode.NODE_VARIABLES_BLANK_NAMES;
    }

    protected ValidationMessageCode getBlankMappedNamesCode(NE NE) {
        return ValidationMessageCode.NODE_VARIABLES_BLANK_MAPPED_NAMES;
    }

    protected ValidationMessageCode getNameBlankCode(NE NE) {
        return ValidationMessageCode.VARIABLE_NAME_BLANK;
    }

    protected ValidationMessageCode getNameInvalidCode(NE NE) {
        return ValidationMessageCode.VARIABLE_NAME_INVALID;
    }

    protected ValidationMessageCode getMappedNameBlankCode(NE NE) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_BLANK;
    }

    protected ValidationMessageCode getMappedNameInvalidCode(NE NE) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_INVALID;
    }

    protected ValidationMessageCode getTypeBlankCode(NE NE) {
        return ValidationMessageCode.VARIABLE_TYPE_BLANK;
    }

    protected ValidationMessageCode getTypeInvalidCode(NE NE) {
        return ValidationMessageCode.VARIABLE_TYPE_INVALID;
    }

    private boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    private boolean matchesPattern(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    private List<String> generateParameters(NE NE, Variable variable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(variable.getName() != null ? variable.getName() : "");
        arrayList.add(variable.getMappedName() != null ? variable.getMappedName() : "");
        return arrayList;
    }
}

