/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllowedNodeTypesRule<G extends IWatchPointGraph>
implements IValidationRule<G> {
    @Override
    public List<ValidationMessage> validateRule(G g) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Set set = g.getVertices();
        for (Vertex vertex : set) {
            this.validateNodeType(WatchPointGraphUtils.getWTVertexElement(vertex), arrayList);
        }
        return arrayList;
    }

    protected void validateNodeType(NodeElement nodeElement, List<ValidationMessage> list) {
        Class<?> clazz = nodeElement.getClass();
        List<Class<NodeElement>> list2 = this.getAllowedNodeTypes();
        if (list2 != null && !list2.contains(clazz)) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_NODE_TYPE;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }

    protected abstract List<Class<? extends NodeElement>> getAllowedNodeTypes();
}

