/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPropertiesRule
implements IValidationRule<ResourceType> {
    private static final String SYSTEM_ID_REGEX = "^(\\p{Alnum}{2})$";

    @Override
    public List<ValidationMessage> validateRule(ResourceType resourceType) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateName(resourceType, arrayList);
        this.validateSystemId(resourceType, arrayList);
        this.validateConnectionType(resourceType, arrayList);
        this.validateDescription(resourceType, arrayList);
        return arrayList;
    }

    private void validateName(ResourceType resourceType, List<ValidationMessage> list) {
        String string = resourceType.getName();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_NAME_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (string.length() > 50) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_NAME_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateSystemId(ResourceType resourceType, List<ValidationMessage> list) {
        String string = resourceType.getSystemId();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (!Pattern.matches(SYSTEM_ID_REGEX, string)) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_INVALID;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateConnectionType(ResourceType resourceType, List<ValidationMessage> list) {
        ConnectionType connectionType = resourceType.getConnectionType();
        if (connectionType == null) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_CONNECTION_TYPE_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateDescription(ResourceType resourceType, List<ValidationMessage> list) {
        String string = resourceType.getDescription();
        if (string != null && string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_DESCRIPTION_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

