/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementPropertiesRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType resourceType) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateInitializationProperties(resourceType, arrayList);
        this.validateHeartbeatProperties(resourceType, arrayList);
        return arrayList;
    }

    protected void validateInitializationProperties(ResourceType resourceType, List<ValidationMessage> list) {
        if (!resourceType.isInitializationRequired()) {
            return;
        }
        String string = resourceType.getInitializationStrategyClass();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_INITIALIZATION_STRATEGY_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_INITIALIZATION_STRATEGY_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    protected void validateHeartbeatProperties(ResourceType resourceType, List<ValidationMessage> list) {
        Object object;
        if (!resourceType.isHeartbeatRequired()) {
            return;
        }
        if (resourceType.getHeartbeatConnectionType() == null) {
            object = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_CONNECTION_TYPE_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if ((object = resourceType.getHeartbeatStrategyClass()) == null || ((String)object).trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_STRATEGY_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (((String)object).length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_HEARTBEAT_STRATEGY_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

