/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms;

import edu.uci.ics.jung.algorithms.MatrixElementOperations;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;

public class RealMatrixElementOperations
implements MatrixElementOperations {
    private String EDGE_KEY;

    public RealMatrixElementOperations(String edge_key) {
        this.EDGE_KEY = edge_key;
    }

    public void mergePaths(Edge e, Object pathData) {
        MutableDouble pd = (MutableDouble)pathData;
        MutableDouble ed = (MutableDouble)e.getUserDatum(this.EDGE_KEY);
        if (ed == null) {
            e.addUserDatum(this.EDGE_KEY, pd, UserData.SHARED);
        } else {
            ed.add(pd.doubleValue());
        }
    }

    public Object computePathData(Edge e1, Edge e2) {
        double d1 = ((MutableDouble)e1.getUserDatum(this.EDGE_KEY)).doubleValue();
        double d2 = ((MutableDouble)e2.getUserDatum(this.EDGE_KEY)).doubleValue();
        return new MutableDouble(d1 * d2);
    }
}

