/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceDAO<EC extends IPersistable, EKC extends Serializable>
implements DataAccessInterface<EC, EKC> {
    private Class<EC> entityClass;
    private JPAPersistenceContext context;

    protected PersistenceDAO(Class<EC> clazz, JPAPersistenceContext jPAPersistenceContext) {
        this.entityClass = clazz;
        this.context = jPAPersistenceContext;
    }

    @Override
    public EC create(EC EC) {
        this.getEntityManager().persist(EC);
        return EC;
    }

    @Override
    public EC update(EC EC) {
        return (EC)((IPersistable)this.getEntityManager().merge(EC));
    }

    @Override
    public void delete(EKC EKC) {
        EC EC = this.find(EKC);
        if (EC != null) {
            this.getEntityManager().remove(EC);
        }
    }

    @Override
    public EC find(EKC EKC) {
        return (EC)((IPersistable)this.getEntityManager().find(this.getEntityClass(), EKC));
    }

    @Override
    public List<EC> findAll() {
        String string = "SELECT entity " + this.getFromClause() + " entity";
        Query query = this.getEntityManager().createQuery(string);
        return query.getResultList();
    }

    @Override
    public EC lock(EKC EKC) {
        EC EC = this.find(EKC);
        if (EC != null) {
            this.getEntityManager().lock(EC, this.getPersistenceContext().getLockMode());
            this.refresh(EC);
        }
        return EC;
    }

    protected void refresh(EC EC) {
        this.getEntityManager().refresh(EC);
    }

    @Override
    public JPAPersistenceContext getPersistenceContext() {
        return this.context;
    }

    protected Object getSingleResultOrNull(Query query) {
        try {
            return query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    protected EntityManager getEntityManager() {
        if (this.context == null || !this.context.isInitialized()) {
            String string = "The Persistence Context has not been initialized, cannot perform data operation.";
            throw new IllegalStateException(string);
        }
        return this.context.getEntityManager();
    }

    protected Class<EC> getEntityClass() {
        return this.entityClass;
    }

    protected String getFromClause() {
        return "FROM " + this.getEntityClass().getName();
    }
}

