/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.ResourceTypeParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypePDAO
extends PersistenceDAO<ResourceType, Long>
implements ResourceTypeDAI {
    private static final Logger logger = Logger.getLogger(ResourceType.class);

    public ResourceTypePDAO(JPAPersistenceContext jPAPersistenceContext) {
        super(ResourceType.class, jPAPersistenceContext);
    }

    @Override
    public ResourceType create(ResourceType resourceType) {
        return this.fetchLazyLoadedCollections(super.create(resourceType));
    }

    @Override
    public ResourceType update(ResourceType resourceType) {
        List<ResourceTypeParameter> list = this.getParametersById(resourceType.getId());
        Map<ParameterMapKey, ResourceTypeParameter> map = this.buildParameterMap(resourceType);
        ParameterMapKey parameterMapKey = new ParameterMapKey(null);
        Iterator<ResourceTypeParameter> iterator = list.iterator();
        while (iterator.hasNext()) {
            ResourceTypeParameter resourceTypeParameter;
            parameterMapKey.parameter = resourceTypeParameter = iterator.next();
            ResourceTypeParameter resourceTypeParameter2 = map.get(parameterMapKey);
            if (resourceTypeParameter2 != null) {
                resourceTypeParameter2.setId(resourceTypeParameter.getId());
                continue;
            }
            this.getEntityManager().remove((Object)resourceTypeParameter);
        }
        return this.fetchLazyLoadedCollections(super.update(resourceType));
    }

    @Override
    public ResourceType find(Long l) {
        return this.fetchLazyLoadedCollections((ResourceType)super.find(l));
    }

    @Override
    public List<ResourceType> findAll() {
        List<ResourceType> list = super.findAll();
        if (list != null) {
            for (ResourceType resourceType : list) {
                if (resourceType.getMessages() == null) continue;
                resourceType.getMessages().size();
            }
        }
        return list;
    }

    @Override
    protected void refresh(ResourceType resourceType) {
        Set<Message> set;
        super.refresh(resourceType);
        Set<ResourceTypeParameter> set2 = resourceType.getParameters();
        if (set2 != null) {
            for (ResourceTypeParameter object2 : set2) {
                this.getEntityManager().refresh((Object)object2);
            }
        }
        if ((set = resourceType.getMessages()) != null) {
            for (Object message : set) {
                this.getEntityManager().refresh(message);
            }
        }
    }

    @Override
    public List<ResourceType> findAllViewable() {
        String string = "ResourceType.Viewable";
        Query query = this.getEntityManager().createNamedQuery(string);
        return query.getResultList();
    }

    @Override
    public ResourceType findBySystemId(String string) {
        String string2 = "ResourceType.BySystemId";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("systemId", (Object)string);
        ResourceType resourceType = null;
        try {
            resourceType = (ResourceType)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            String string3 = "Cannot find a Resource Type with System Id: " + string + ", return null.";
            logger.debug((Object)string3, (Throwable)noResultException);
            resourceType = null;
        }
        return this.fetchLazyLoadedCollections(resourceType);
    }

    @Override
    public ResourceType findByName(String string) {
        String string2 = "ResourceType.ByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        ResourceType resourceType = null;
        try {
            resourceType = (ResourceType)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            String string3 = "Cannot find a Resource Type with Name: " + string + ", return null.";
            logger.debug((Object)string3, (Throwable)noResultException);
            resourceType = null;
        }
        return this.fetchLazyLoadedCollections(resourceType);
    }

    @Override
    public int getCountByName(String string) {
        String string2 = "ResourceType.CountByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        Long l = (Long)query.getSingleResult();
        return l.intValue();
    }

    @Override
    public int getCountBySystemId(String string) {
        String string2 = "ResourceType.CountBySystemId";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("systemId", (Object)string);
        Long l = (Long)query.getSingleResult();
        return l.intValue();
    }

    @Override
    public List<Message> getMessagesById(long l) {
        String string = "ResourceType.MessagesById";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("id", (Object)l);
        return query.getResultList();
    }

    @Override
    public List<Message> getMessagesByUid(Set<String> set) {
        String string2;
        if (set == null || set.size() == 0) {
            return new ArrayList<Message>();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT NEW com.tandbergtv.watchpoint.studio.dto.Message(msg.id, msg.name) ");
        stringBuilder.append("FROM com.tandbergtv.watchpoint.studio.dto.Message msg ");
        stringBuilder.append("WHERE msg.uid IN ( ");
        boolean bl = true;
        for (String string2 : set) {
            if (string2 == null || string2.trim().length() == 0) continue;
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append("'");
            stringBuilder.append(string2);
            stringBuilder.append("'");
        }
        stringBuilder.append(" ) ");
        string2 = this.getEntityManager().createQuery(stringBuilder.toString());
        return string2.getResultList();
    }

    @Override
    public boolean isOutOfTheBox(long l) {
        String string = "ResourceType.OutOfTheBoxById";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("id", (Object)l);
        return (Boolean)query.getSingleResult();
    }

    private Map<ParameterMapKey, ResourceTypeParameter> buildParameterMap(ResourceType resourceType) {
        HashMap<ParameterMapKey, ResourceTypeParameter> hashMap = new HashMap<ParameterMapKey, ResourceTypeParameter>();
        Set<ResourceTypeParameter> set = resourceType.getAllParameters();
        for (ResourceTypeParameter resourceTypeParameter : set) {
            hashMap.put(new ParameterMapKey(resourceTypeParameter), resourceTypeParameter);
        }
        return hashMap;
    }

    private List<ResourceTypeParameter> getParametersById(long l) {
        String string = "ResourceType.ParametersById";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("id", (Object)l);
        return query.getResultList();
    }

    private ResourceType fetchLazyLoadedCollections(ResourceType resourceType) {
        if (resourceType != null) {
            if (resourceType.getMessages() != null) {
                resourceType.getMessages().size();
            }
            if (resourceType.getParameters() != null) {
                resourceType.getParameters();
            }
        }
        return resourceType;
    }

    private class ParameterMapKey {
        ResourceTypeParameter parameter;

        ParameterMapKey(ResourceTypeParameter resourceTypeParameter) {
            this.parameter = resourceTypeParameter;
        }

        public int hashCode() {
            if (this.parameter == null || this.parameter.getName() == null) {
                return super.hashCode();
            }
            return this.parameter.getName().hashCode() * 4 - this.parameter.getType().hashCode() * 3 + 373;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ParameterMapKey)) {
                return false;
            }
            ResourceTypeParameter resourceTypeParameter = ((ParameterMapKey)object).parameter;
            if (this.parameter == null && resourceTypeParameter == null) {
                return super.equals(object);
            }
            String string = this.parameter.getName();
            return this.parameter.getType() == resourceTypeParameter.getType() && string != null && string.equals(resourceTypeParameter.getName());
        }
    }
}

