/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateDTOPDAO
extends PersistenceDAO<WorkflowTemplateDTO, Long>
implements WorkflowTemplateDTODAI {
    public WorkflowTemplateDTOPDAO(JPAPersistenceContext jPAPersistenceContext) {
        super(WorkflowTemplateDTO.class, jPAPersistenceContext);
    }

    @Override
    public List<WorkflowTemplateDTO> findAll() {
        String string = "WorkflowTemplateDTO.All";
        Query query = this.getEntityManager().createNamedQuery(string);
        return query.getResultList();
    }

    @Override
    public List<WorkflowTemplateDTO> findByCurrentVersion() {
        String string = "WorkflowTemplateDTO.ByCurrentVersion";
        Query query = this.getEntityManager().createNamedQuery(string);
        return this.buildTemplates(query.getResultList());
    }

    @Override
    public List<WorkflowTemplateDTO> findByNodeDefinitionUsage(long l) {
        String string = "WorkflowTemplateDTO.ByNodeDefinitionUsage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        return this.buildTemplates(query.getResultList());
    }

    @Override
    public WorkflowTemplateDTO findByName(String string) {
        String string2 = "WorkflowTemplateDTO.ByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (WorkflowTemplateDTO)query.getSingleResult();
    }

    @Override
    public Long getTemplateIdByName(String string) {
        String string2 = "WorkflowTemplateDTO.IdByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (Long)query.getSingleResult();
    }

    @Override
    public Long getTemplateIdByNameForOldestVersion(String string) {
        String string2 = "WorkflowTemplateDTO.IdByNameForOldestVersion";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (Long)query.getSingleResult();
    }

    @Override
    public Integer getCurrentVersionNumberByName(String string) {
        String string2 = "WorkflowTemplateDTO.CurrentVersionByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return (Integer)query.getSingleResult();
    }

    @Override
    public int getCountByName(String string) {
        String string2 = "WorkflowTemplateDTO.CountByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        Long l = (Long)query.getSingleResult();
        return l.intValue();
    }

    @Override
    public int getCountByNodeDefinitionUsage(long l) {
        String string = "WorkflowTemplateDTO.CountByNodeDefinitionUsage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    @Override
    public int getCountByResourceGroupUsage(long l) {
        String string = "WorkflowTemplateDTO.CountByResourceGroupUsage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceGroupId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    @Override
    public int setInactiveByName(String string) {
        String string2 = "WorkflowTemplateDTO.Update.InactiveByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        return query.executeUpdate();
    }

    @Override
    public void deleteNodeDefinitionReferences(long l) {
        String string = "DELETE TB_NODEDEFINITIONTEMPLATEMAP WHERE NODEDEFINITIONID = :nodeDefinitionId";
        Query query = this.getEntityManager().createNativeQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        query.executeUpdate();
    }

    @Override
    public void deleteResourceGroupMap(String string) {
        String string2 = "DELETE TB_RESOURCEGROUPTEMPLATEMAP WHERE TEMPLATEID IN (SELECT TEMPLATEID FROM TB_TEMPLATE WHERE NAME = :templateName)";
        Query query = this.getEntityManager().createNativeQuery(string2);
        query.setParameter("templateName", (Object)string);
        query.executeUpdate();
    }

    private List<WorkflowTemplateDTO> buildTemplates(List<?> list) {
        ArrayList<WorkflowTemplateDTO> arrayList = new ArrayList<WorkflowTemplateDTO>();
        if (list != null) {
            for (Object obj : list) {
                Object[] objectArray = (Object[])obj;
                WorkflowTemplateDTO workflowTemplateDTO = new WorkflowTemplateDTO();
                int n = 0;
                while (n < objectArray.length) {
                    switch (n) {
                        case 0: {
                            workflowTemplateDTO.setId((Long)objectArray[0]);
                            break;
                        }
                        case 1: {
                            workflowTemplateDTO.setName((String)objectArray[1]);
                            break;
                        }
                        case 2: {
                            workflowTemplateDTO.setExportable((Boolean)objectArray[2]);
                            break;
                        }
                        case 3: {
                            workflowTemplateDTO.setVersion((Integer)objectArray[3]);
                            break;
                        }
                        case 4: {
                            workflowTemplateDTO.setDirty((Boolean)objectArray[4]);
                            break;
                        }
                        case 5: {
                            workflowTemplateDTO.setLock((ILock)objectArray[5]);
                            break;
                        }
                        case 6: {
                            workflowTemplateDTO.setActive((Boolean)objectArray[6]);
                        }
                    }
                    ++n;
                }
                arrayList.add(workflowTemplateDTO);
            }
        }
        return arrayList;
    }
}

