/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPFExportUtil {
    private static final String LIBRARY_ID_PREFIX = "_library_";
    private static final int VALUE_ATTRIBUTE_SIZE_LIMIT = 300;

    private JPFExportUtil() {
    }

    public static Document createPluginDocument(String string, String string2) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType("plugin", "-//JPF//Java Plug-in Manifest 1.0", "http://jpf.sourceforge.net/plugin_1_0.dtd");
        Document document = dOMImplementation.createDocument("", "plugin", documentType);
        Element element = document.getDocumentElement();
        element.setAttribute("id", string);
        element.setAttribute("version", string2);
        return document;
    }

    public static final void addPluginDependency(Document document, String string) {
        List<String> list;
        if (string == null || string.trim().length() == 0) {
            String string2 = "The Plugin ID specified as a dependent cannot be null or blank.";
            throw new IllegalArgumentException(string2);
        }
        Element element = document.getDocumentElement();
        Element element2 = JPFExportUtil.findOrCreateElement("requires", element, list = Arrays.asList("runtime", "extension-point", "extension"));
        NodeList nodeList = element2.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    Element element3 = (Element)node;
                    String string3 = node.getNodeName();
                    String string4 = element3.getAttribute("plugin-id");
                    if ("import".equals(string3) && string.equals(string4)) {
                        return;
                    }
                }
                ++n;
            }
        }
        Element element4 = document.createElement("import");
        element4.setAttribute("plugin-id", string);
        element2.appendChild(element4);
    }

    public static final void addRuntimeLibraries(Document document, List<String> list, List<String> list2) {
        int n;
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (list2 == null) {
            list2 = new ArrayList<String>();
        }
        if ((n = list.size() + list2.size()) == 0) {
            return;
        }
        Element element = document.getDocumentElement();
        List<String> list3 = Arrays.asList("extension-point", "extension");
        Element element2 = JPFExportUtil.findOrCreateElement("runtime", element, list3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element2.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && "library".equals(node.getNodeName())) {
                    Element element3 = (Element)node;
                    String string = element3.getAttribute("id");
                    String string2 = element3.getAttribute("path");
                    hashMap.put(string, string2);
                }
                ++n2;
            }
        }
        JPFExportUtil.addLibraries(element2, list, "code", hashMap);
        JPFExportUtil.addLibraries(element2, list2, "resources", hashMap);
    }

    public static Element addExtension(Document document, String string, String string2, String string3) {
        Element element = document.createElement("extension");
        element.setAttribute("id", string);
        element.setAttribute("plugin-id", string2);
        element.setAttribute("point-id", string3);
        document.getDocumentElement().appendChild(element);
        return element;
    }

    public static Element addParameter(Element element, String string) {
        return JPFExportUtil.addParameter(element, string, null);
    }

    public static Element addParameter(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("parameter");
        element2.setAttribute("id", string);
        if (JPFExportUtil.requiresValueElement(string2)) {
            Element element3 = document.createElement("value");
            string2 = string2.replace(System.getProperty("line.separator"), "\n");
            element3.setTextContent(string2);
            element2.appendChild(element3);
        } else if (string2 != null) {
            element2.setAttribute("value", string2);
        }
        element.appendChild(element2);
        return element2;
    }

    private static boolean requiresValueElement(String string) {
        if (string == null) {
            return false;
        }
        return string.length() > 300 || string.contains(System.getProperty("line.separator")) || string.contains("\n");
    }

    private static Element findOrCreateElement(String string, Element element, List<String> list) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = null;
        if (nodeList == null || nodeList.getLength() == 0) {
            element2 = element.getOwnerDocument().createElement(string);
            Node node = element.getFirstChild();
            NodeList nodeList2 = element.getChildNodes();
            if (nodeList2 != null) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                int n = 0;
                while (n < nodeList2.getLength()) {
                    Node node2 = nodeList2.item(n);
                    if (node2.getNodeType() == 1) {
                        if (list.contains(node2.getNodeName())) break;
                        node = node2.getNextSibling();
                    }
                    ++n;
                }
            }
            element.insertBefore(element2, node);
        } else {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private static void addLibraries(Element element, List<String> list, String string, Map<String, String> map) {
        int n = 1;
        for (String string2 : list) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElement("library");
            String string3 = String.valueOf(string) + LIBRARY_ID_PREFIX;
            String string4 = null;
            String string5 = null;
            do {
                if ((string5 = Integer.toString(n++)).length() != 1) continue;
                string5 = "0" + string5;
            } while (map.containsKey(string4 = String.valueOf(string3) + string5));
            element2.setAttribute("path", string2);
            element2.setAttribute("id", string4);
            element2.setAttribute("type", string);
            element.appendChild(element2);
        }
    }
}

