/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupExporter
extends WatchPointPluginExporter<ResourceGroup> {
    private static final String EXTENSION_ID_SUFFIX = " Resource Group";
    private static final String TASK_IMAGE_DIR = "images";
    private static final String DEFAULT_TASK_IMAGE_FILE_NAME = "taskImage";

    @Override
    protected String getPluginId(ResourceGroup resourceGroup, Map<String, Object> map) {
        return String.valueOf(resourceGroup.getName()) + EXTENSION_ID_SUFFIX;
    }

    @Override
    protected String getPluginVersion(ResourceGroup resourceGroup, Map<String, Object> map) {
        return String.valueOf(resourceGroup.getVersion());
    }

    @Override
    protected void addPluginPointsAndExtensions(ResourceGroup resourceGroup, Map<String, Object> map, Document document, File file) throws ExportFailureException {
        String string = String.valueOf(resourceGroup.getName()) + EXTENSION_ID_SUFFIX;
        Element element = JPFExportUtil.addExtension(document, string, "com.tandbergtv.workflow", "resourcegroup");
        if (this.isNotNullAndNotBlank(resourceGroup.getName())) {
            JPFExportUtil.addParameter(element, "name", resourceGroup.getName());
        }
        if (resourceGroup.getResourceType() != null && this.isNotNullAndNotBlank(resourceGroup.getResourceType().getSystemId())) {
            JPFExportUtil.addParameter(element, "systemId", resourceGroup.getResourceType().getSystemId());
        }
        if (this.isNotNullAndNotBlank(resourceGroup.getFunctionalType())) {
            JPFExportUtil.addParameter(element, "functionalType", resourceGroup.getFunctionalType());
        }
        if (resourceGroup.getProtectionKey() != null && this.isNotNullAndNotBlank(resourceGroup.getProtectionKey().getName())) {
            JPFExportUtil.addParameter(element, "accessLevel", resourceGroup.getProtectionKey().getName());
        }
        JPFExportUtil.addParameter(element, "isInternallyAcquired", String.valueOf(resourceGroup.isInternallyAcquired()));
        if (this.isNotNullAndNotBlank(resourceGroup.getAllocationStrategyClassName())) {
            JPFExportUtil.addParameter(element, "allocationStrategyClass", resourceGroup.getAllocationStrategyClassName());
        }
        if (resourceGroup.getImageContent() != null && resourceGroup.getImageContent().length > 0) {
            File file2 = new File(this.getPluginResourcesFolder(file), TASK_IMAGE_DIR);
            String string2 = this.isNotNullAndNotBlank(resourceGroup.getImageFileName()) ? resourceGroup.getImageFileName() : DEFAULT_TASK_IMAGE_FILE_NAME;
            File file3 = new File(file2, string2);
            try {
                file2.mkdirs();
                this.writeToFile(resourceGroup.getImageContent(), file3);
            }
            catch (IOException iOException) {
                String string3 = "IO Exception caught while exporting the image (writing image content to file). Ensure that the export folder is accessible.";
                throw new ExportFailureException(string3, iOException);
            }
            JPFExportUtil.addParameter(element, "imagePath", "images/" + string2);
        }
    }

    private boolean isNotNullAndNotBlank(String string) {
        return string != null && string.trim().length() > 0;
    }

    private void writeToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

