/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginExporter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeExporter
extends WatchPointPluginExporter<ResourceType> {
    private static final String PLUGIN_ID_PREFIX = "ResourceTypePlugin_";
    private static final String EXTENSION_ID_PREFIX = "ResourceType_";
    private static final String JPF_DATE_FORMAT = "yyyy-MM-dd";

    @Override
    protected String getPluginId(ResourceType resourceType, Map<String, Object> map) {
        return PLUGIN_ID_PREFIX + resourceType.getSystemId();
    }

    @Override
    protected String getPluginVersion(ResourceType resourceType, Map<String, Object> map) {
        return Integer.toString(resourceType.getVersion());
    }

    @Override
    protected void addPluginPointsAndExtensions(ResourceType resourceType, Map<String, Object> map, Document document, File file) {
        this.addResourceTypeExtension(document, resourceType, map);
    }

    private void addResourceTypeExtension(Document document, ResourceType resourceType, Map<String, Object> map) {
        String string = EXTENSION_ID_PREFIX + resourceType.getSystemId();
        Element element = JPFExportUtil.addExtension(document, string, "com.tandbergtv.workflow", "resourcetype");
        this.addBasicParameters(element, resourceType, map);
        this.addCommunicationParameter(element, resourceType, map);
        this.addManagementParameter(element, resourceType, map);
    }

    private void addBasicParameters(Element element, ResourceType resourceType, Map<String, Object> map) {
        JPFExportUtil.addParameter(element, "systemId", resourceType.getSystemId());
        JPFExportUtil.addParameter(element, "name", resourceType.getName());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(JPF_DATE_FORMAT);
        String string = simpleDateFormat.format(resourceType.getCreateDate());
        JPFExportUtil.addParameter(element, "createDate", string);
        String string2 = resourceType.getDescription();
        if (string2 != null && string2.trim().length() > 0) {
            JPFExportUtil.addParameter(element, "description", string2);
        }
    }

    private void addCommunicationParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        int n;
        Set<Message> set = resourceType.getMessages();
        int n2 = n = set != null ? set.size() : 0;
        if (n == 0) {
            return;
        }
        Element element2 = JPFExportUtil.addParameter(element, "communication");
        this.addMessagesParameter(element2, resourceType, map);
        this.addAdaptorParameter(element2, resourceType, map);
    }

    private void addMessagesParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        Element element2 = JPFExportUtil.addParameter(element, "messages");
        String string = resourceType.getDefaultProtocol();
        if (string == null) {
            string = "";
        }
        JPFExportUtil.addParameter(element2, "defaultProtocol", string);
        ArrayList<Message> arrayList = new ArrayList<Message>(resourceType.getMessages());
        Collections.sort(arrayList, new Comparator<Message>(){

            @Override
            public int compare(Message message, Message message2) {
                String string = message != null ? message.getUid() : "";
                String string2 = message2 != null ? message2.getUid() : "";
                return string.compareTo(string2);
            }
        });
        for (Message message : arrayList) {
            this.addMessageParameter(element2, message, string, map);
        }
    }

    private void addMessageParameter(Element element, Message message, String string, Map<String, Object> map) {
        String string2;
        Element element2 = JPFExportUtil.addParameter(element, "message");
        JPFExportUtil.addParameter(element2, "name", message.getName());
        JPFExportUtil.addParameter(element2, "uid", message.getUid());
        String string3 = message.getDescription();
        if (string3 != null && string3.trim().length() > 0) {
            JPFExportUtil.addParameter(element2, "description", string3);
        }
        if ((string2 = message.getProtocol()) != null && string2.trim().length() > 0 && !string2.equals(string)) {
            JPFExportUtil.addParameter(element2, "protocol", string2);
        }
    }

    private void addAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        Element element2 = JPFExportUtil.addParameter(element, "adaptor");
        if (resourceType.getAdaptorType() == AdaptorType.DEFAULT) {
            this.addDefaultAdaptorParameter(element2, resourceType, map);
        } else if (resourceType.getAdaptorType() == AdaptorType.CUSTOM) {
            this.addCustomAdaptorParameter(element2, resourceType, map);
        }
    }

    private void addDefaultAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        Element element2 = JPFExportUtil.addParameter(element, "default");
        String string = resourceType.getMessageIdentificationClassName();
        if (string != null && string.trim().length() > 0) {
            JPFExportUtil.addParameter(element2, "messageIdentifierClass", string);
        }
    }

    private void addCustomAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        Element element2 = JPFExportUtil.addParameter(element, "custom");
        JPFExportUtil.addParameter(element2, "class", resourceType.getAdaptorClassName());
        String string = this.getScopeValue(resourceType.getAdaptorScope());
        if (string != null) {
            JPFExportUtil.addParameter(element2, "scope", string);
        }
        Map<String, String> map2 = resourceType.getAdaptorParameters();
        this.addResourceTypeParameters(element2, map2, "init-params", "parameter", "key", "value");
    }

    private void addManagementParameter(Element element, ResourceType resourceType, Map<String, Object> map) {
        Element element2 = JPFExportUtil.addParameter(element, "management");
        String string = resourceType.getConnectionType().getName();
        JPFExportUtil.addParameter(element2, "connectionType", string);
        this.addInitializationParameters(element2, resourceType, map);
        this.addHeartbeatParameters(element2, resourceType, map);
    }

    private void addInitializationParameters(Element element, ResourceType resourceType, Map<String, Object> map) {
        if (!resourceType.isInitializationRequired()) {
            return;
        }
        Element element2 = JPFExportUtil.addParameter(element, "initialization");
        JPFExportUtil.addParameter(element2, "strategyClass", resourceType.getInitializationStrategyClass());
        Map<String, String> map2 = resourceType.getInitializationParameters();
        this.addResourceTypeParameters(element2, map2, "init-params", "parameter", "key", "value");
    }

    private void addHeartbeatParameters(Element element, ResourceType resourceType, Map<String, Object> map) {
        if (!resourceType.isHeartbeatRequired()) {
            return;
        }
        Element element2 = JPFExportUtil.addParameter(element, "heartbeat");
        JPFExportUtil.addParameter(element2, "connectionType", resourceType.getHeartbeatConnectionType().getName());
        JPFExportUtil.addParameter(element2, "strategyClass", resourceType.getHeartbeatStrategyClass());
        Map<String, String> map2 = resourceType.getHeartbeatParameters();
        this.addResourceTypeParameters(element2, map2, "init-params", "parameter", "key", "value");
    }

    private void addResourceTypeParameters(Element element, Map<String, String> map, String string, String string2, String string3, String string4) {
        if (map == null || map.size() == 0) {
            return;
        }
        Element element2 = JPFExportUtil.addParameter(element, string);
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string5 : arrayList) {
            String string6 = map.get(string5);
            Element element3 = JPFExportUtil.addParameter(element2, string2);
            JPFExportUtil.addParameter(element3, string3, string5);
            JPFExportUtil.addParameter(element3, string4, string6);
        }
    }

    private String getScopeValue(AdaptorScope adaptorScope) {
        String string = null;
        if (adaptorScope == null) {
            return string;
        }
        switch (adaptorScope) {
            case APPLICATION: {
                string = "application";
                break;
            }
            case MESSAGE: {
                string = "message";
            }
        }
        return string;
    }
}

