/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPointPluginExporter<T extends IWatchPointDTO>
implements IWatchPointDTOExporter<T> {
    private static final Logger logger = Logger.getLogger(WatchPointPluginExporter.class);
    private static final String PLUGIN_FILE_NAME = "plugin.xml";
    protected static final String GENERIC_EXCEPTION_MESSAGE = "Ensure that the export folder is accessible.";
    protected static final String FILE_SEPARATOR = "/";

    @Override
    public Map<String, Object> export(T t, Map<String, Object> map) throws ExportFailureException {
        try {
            File file = this.getPluginFolder(t, map);
            Document document = this.buildPluginDocument(t, map);
            this.addPluginDependencies(t, map, document, file);
            this.handleRuntimeLibraries(t, map, document, file);
            this.addPluginPointsAndExtensions(t, map, document, file);
            this.writePluginDocument(t, map, document, file);
            return new HashMap<String, Object>();
        }
        catch (ExportFailureException exportFailureException) {
            throw exportFailureException;
        }
        catch (Exception exception) {
            String string = "Failed to export the WatchPoint Plugin.";
            throw new ExportFailureException(string, exception);
        }
    }

    protected File getPluginFolder(T t, Map<String, Object> map) throws ExportFailureException {
        String string = (String)map.get("exportFolderPath");
        if (string == null) {
            String string2 = "No Output Folder provided for export of WatchPoint Plugin, property: exportFolderPath must be assigned with the value of an existing folder pathin the export inputs when exporting a WatchPoint plugin.";
            throw new ExportFailureException(string2);
        }
        File file = new File(string);
        string = file.getAbsolutePath();
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            String string3 = "The specified output folder for export of WatchPoint Plugin is not a folder: " + string;
            throw new ExportFailureException(string3);
        }
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            boolean bl;
            Object object = map.get("deleteFolderContents");
            boolean bl2 = bl = object != null ? (Boolean)object : false;
            if (bl) {
                if (!FileUtil.deleteFolderContents(file, true)) {
                    String string4 = "Failed to delete the contents of the specified output folder for export of WatchPoint Plugin: " + string + ". " + GENERIC_EXCEPTION_MESSAGE;
                    throw new ExportFailureException(string4);
                }
            } else {
                String string5 = "The specified output folder for export of WatchPoint Plugin is not empty, delete the contents of this folder before exporting: " + string;
                throw new ExportFailureException(string5);
            }
        }
        return file;
    }

    protected Document buildPluginDocument(T t, Map<String, Object> map) throws ExportFailureException {
        String string = this.getPluginId(t, map);
        String string2 = this.getPluginVersion(t, map);
        try {
            return JPFExportUtil.createPluginDocument(string, string2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = "Export failed, unable to build the plugin XML document.";
            throw new ExportFailureException(string3, parserConfigurationException);
        }
    }

    protected void addPluginDependencies(T t, Map<String, Object> map, Document document, File file) {
        JPFExportUtil.addPluginDependency(document, "com.tandbergtv.workflow");
    }

    protected void handleRuntimeLibraries(T t, Map<String, Object> map, Document document, File file) throws ExportFailureException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = "lib";
        Object object = map.get("jarFilePathList");
        List list = (List)object;
        this.copyRuntimeFiles(file, string, list, arrayList, true);
        string = "classes";
        object = map.get("classFilePathList");
        list = (List)object;
        this.copyRuntimeFiles(file, string, list, arrayList, false);
        string = "resources";
        object = map.get("resourceFilePathList");
        list = (List)object;
        this.copyRuntimeFiles(file, string, list, arrayList2, false);
        JPFExportUtil.addRuntimeLibraries(document, arrayList, arrayList2);
    }

    protected void writePluginDocument(T t, Map<String, Object> map, Document document, File file) throws ExportFailureException {
        String string = null;
        Writer writer = null;
        try {
            try {
                File file2 = new File(file, PLUGIN_FILE_NAME);
                string = file2.getAbsolutePath();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setAttribute("indent-number", "4");
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("doctype-public", "-//JPF//Java Plug-in Manifest 1.0");
                transformer.setOutputProperty("doctype-system", "http://jpf.sourceforge.net/plugin_1_0.dtd");
                transformer.setOutputProperty("indent", "yes");
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
            catch (Exception exception) {
                String string2 = "Failed to write the Plugin document to the file: " + string + ". " + GENERIC_EXCEPTION_MESSAGE;
                throw new ExportFailureException(string2, exception);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    String string3 = "Failed to close file stream after writing WatchPoint Plugin file: " + string;
                    logger.warn((Object)string3, (Throwable)iOException);
                }
            }
        }
    }

    protected final File getPluginLibFolder(File file) {
        String string = "lib";
        return this.getLibraryFolder(file, string);
    }

    protected final File getPluginClassesFolder(File file) {
        String string = "classes";
        return this.getLibraryFolder(file, string);
    }

    protected final File getPluginResourcesFolder(File file) {
        String string = "resources";
        return this.getLibraryFolder(file, string);
    }

    protected abstract String getPluginId(T var1, Map<String, Object> var2);

    protected abstract String getPluginVersion(T var1, Map<String, Object> var2);

    protected abstract void addPluginPointsAndExtensions(T var1, Map<String, Object> var2, Document var3, File var4) throws ExportFailureException;

    private File getLibraryFolder(File file, String string) {
        File file2;
        String string2 = string == null ? "" : string.trim();
        File file3 = file2 = string2.length() > 0 ? new File(file, string2) : file;
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    private void copyRuntimeFiles(File file, String string, List<String> list, List<String> list2, boolean bl) throws ExportFailureException {
        String string2;
        if (list == null) {
            list = new ArrayList<String>();
        }
        String string3 = file.getAbsolutePath();
        int n = string3.length();
        if (!string3.endsWith(File.separator)) {
            ++n;
        }
        File file2 = this.getLibraryFolder(file, string);
        Object object = list.iterator();
        while (object.hasNext()) {
            String string4;
            string2 = object.next();
            File file3 = new File(string2);
            File file4 = new File(file2, file3.getName());
            if (bl && !file3.isFile()) {
                string4 = "Failure when attempting to copy file: " + file3.getAbsolutePath() + ", source is not a file.";
                throw new ExportFailureException(string4);
            }
            if (!FileUtil.copyFileOrFolder(file3, file4, true)) {
                string4 = "Failed to copy file/folder: " + file3.getAbsolutePath() + " to location: " + file4.getAbsolutePath() + " required for export of WatchPoint Plugin. " + GENERIC_EXCEPTION_MESSAGE;
                throw new ExportFailureException(string4);
            }
            if (!bl) continue;
            string4 = file4.getAbsolutePath();
            String string5 = string4.substring(n);
            this.addJPFCompliantLibraryPath(string5, list2);
        }
        if (!bl) {
            string2 = file2.getAbsolutePath();
            Object object2 = object = n >= string2.length() ? File.separator : string2.substring(n);
            if (!((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + File.separator;
            }
            this.addJPFCompliantLibraryPath((String)object, list2);
        }
    }

    private void addJPFCompliantLibraryPath(String string, List<String> list) {
        if (string == null) {
            return;
        }
        if (!list.contains(string = string.replaceAll("\\\\", FILE_SEPARATOR))) {
            list.add(string);
        }
    }
}

