/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPTransition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.util.ConvertExprUtility;
import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowTemplateExporter
implements IWatchPointDTOExporter<WorkflowTemplateDTO> {
    private static final String MODEL_ID = "ModelForExport";
    private static final Lock MODEL_LOCK = new ReentrantLock();

    @Override
    public Map<String, Object> export(WorkflowTemplateDTO workflowTemplateDTO, Map<String, Object> map) throws ExportFailureException {
        try {
            String string = workflowTemplateDTO.getXml().replaceAll("\r", "");
            Map<String, Object> map2 = this.createWorkflowTemplate(string);
            WorkflowTemplate workflowTemplate = null;
            workflowTemplate = (WorkflowTemplate)SemanticElementUtil.getSemanticElement(map2);
            this.convertExpression((NodeElementContainer)workflowTemplate);
            this.checkAndFixSuperStateNodeNames(workflowTemplate);
            this.addResourceReleaseActions(workflowTemplate);
            this.addResourceRequestActions(workflowTemplate);
            this.removeNodeDefinitions((NodeElementContainer)workflowTemplate);
            return map2;
        }
        catch (ExportFailureException exportFailureException) {
            throw exportFailureException;
        }
        catch (Exception exception) {
            String string = "Failed to export the Workflow Template.";
            throw new ExportFailureException(string, exception);
        }
    }

    private Map<String, Object> createWorkflowTemplate(String string) throws ExportFailureException {
        MODEL_LOCK.lock();
        try {
            Map<String, Object> map = SemanticElementUtil.createSemanticElement(MODEL_ID, string, "org.jbpm.gd.jpdl.processDefinition");
            return map;
        }
        catch (Exception exception) {
            String string2 = "Failed to construct Semantic Element: WorkflowTemplate from the XML String.";
            throw new ExportFailureException(string2, exception);
        }
        finally {
            MODEL_LOCK.unlock();
        }
    }

    private void convertExpression(NodeElementContainer nodeElementContainer) {
        NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
        if (nodeElementArray == null) {
            return;
        }
        NodeElement[] nodeElementArray2 = nodeElementArray;
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray2[n2];
            this.convertNodeExpressions(nodeElement, nodeElementContainer);
            ++n2;
        }
    }

    private void convertNodeExpressions(NodeElement nodeElement, NodeElementContainer nodeElementContainer) {
        Object object;
        Object object2;
        String string;
        Transition[] transitionArray;
        if (!(nodeElement instanceof AutomaticTaskNode) && nodeElement instanceof IDueDateElement) {
            String string2;
            transitionArray = (Transition[])nodeElement;
            string = transitionArray.getDueDate();
            if (string != null && string.trim().length() > 0) {
                object2 = ConvertExprUtility.convertTimerExpression(string);
                transitionArray.setDueDate((String)object2);
            }
            if (nodeElement instanceof IDurationElement && (string2 = (object2 = (IDurationElement)nodeElement).getDuration()) != null && string2.trim().length() > 0) {
                object = ConvertExprUtility.convertTimerExpression(string2);
                object2.setDuration((String)object);
            }
        }
        if (nodeElement instanceof Decision && (string = (transitionArray = (Decision)nodeElement).getExpression()) != null && string.trim().length() > 0) {
            object2 = ConvertExprUtility.convertDecisionExpression(string);
            transitionArray.setExpression((String)object2);
        }
        if (nodeElement instanceof NodeDefinition && (transitionArray = (NodeDefinition)nodeElement).getNodeType() == NodeDefinitionType.SuperState) {
            this.convertExpression((NodeElementContainer)transitionArray);
        }
        object = transitionArray = nodeElement.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3;
            string = object[n2];
            Condition condition = string.getCondition();
            String string4 = string3 = condition != null ? condition.getExpression() : null;
            if (string3 != null && string3.trim().length() > 0) {
                String string5 = ConvertExprUtility.convertDecisionExpression(string3);
                condition.setExpression(string5);
            }
            ++n2;
        }
    }

    private void checkAndFixSuperStateNodeNames(WorkflowTemplate workflowTemplate) {
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof NodeDefinition && ((NodeDefinition)nodeElement).getNodeType() != NodeDefinitionType.SingleNode) {
                NodeGroup nodeGroup = (NodeGroup)((NodeDefinition)nodeElement).getNode();
                NodeElement[] nodeElementArray2 = nodeGroup.getNodeElements();
                int n3 = nodeElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    NodeElement nodeElement2 = nodeElementArray2[n4];
                    int n5 = 1;
                    boolean bl = false;
                    String string = nodeElement2.getName();
                    String string2 = null;
                    while (workflowTemplate.getNodeElementByName(nodeElement2.getName()) != null) {
                        string2 = String.valueOf(nodeElement2.getNamePrefix()) + n5;
                        ++n5;
                        if (nodeGroup.getNodeElementByName(string2) != null) continue;
                        nodeElement2.setName(string2);
                        bl = true;
                    }
                    if (bl) {
                        NodeElement[] nodeElementArray3 = nodeGroup.getNodeElements();
                        int n6 = nodeElementArray3.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            NodeElement nodeElement3 = nodeElementArray3[n7];
                            Transition[] transitionArray = nodeElement3.getTransitions();
                            int n8 = transitionArray.length;
                            int n9 = 0;
                            while (n9 < n8) {
                                Transition transition = transitionArray[n9];
                                if (transition.getTo().equals(string)) {
                                    transition.setTo(string2);
                                }
                                ++n9;
                            }
                            ++n7;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addResourceReleaseActions(WorkflowTemplate workflowTemplate) {
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)nodeElement).getResourceGroup()) != null && resourceGroup.getName() != null && resourceGroup.getName().length() != 0) {
                Action action = this.createAction(nodeElement.getTransitions()[0].getFactory());
                action.setRefName("resource-release");
                this.addRefAction((WPTransition)nodeElement.getTransitions()[0], action);
            }
            ++n2;
        }
    }

    private void addResourceRequestActions(WorkflowTemplate workflowTemplate) {
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)nodeElement).getResourceGroup()) != null && resourceGroup.getName() != null && resourceGroup.getName().length() != 0) {
                NodeElement[] nodeElementArray2 = workflowTemplate.getNodeElements();
                int n3 = nodeElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    NodeElement nodeElement2 = nodeElementArray2[n4];
                    Transition[] transitionArray = nodeElement2.getTransitions();
                    int n5 = transitionArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Transition transition = transitionArray[n6];
                        if (transition.getTo().equals(nodeElement.getName()) || transition.getTo().equals("/" + nodeElement.getName())) {
                            Action action = this.createAction(transition.getFactory());
                            action.setRefName("resource-request");
                            this.addRefAction((WPTransition)transition, action);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void removeNodeDefinitions(NodeElementContainer nodeElementContainer) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
        if (nodeElementArray == null) {
            return;
        }
        NodeElement[] nodeElementArray2 = nodeElementArray;
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement2 = nodeElementArray2[n2];
            if (nodeElement2 instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)nodeElement2;
                this.removeUnmappedNodeDefinitionVariables(nodeDefinition);
                arrayList.add(nodeDefinition.getNode());
                bl = true;
                switch (nodeDefinition.getNodeType()) {
                    case SingleNode: {
                        this.fixSingleNodeNodeDefinition(nodeElementContainer, nodeDefinition);
                        break;
                    }
                    case SuperState: {
                        WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
                        this.fixSuperStateNodeDefinition(workflowTemplate, nodeDefinition);
                    }
                }
            } else {
                arrayList.add(nodeElement2);
            }
            ++n2;
        }
        if (bl) {
            nodeElementArray2 = nodeElementContainer.getNodeElements();
            n = nodeElementArray2.length;
            n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray2[n2];
                nodeElementContainer.removeNodeElement(nodeElement);
                ++n2;
            }
            for (NodeElement nodeElement : arrayList) {
                nodeElementContainer.addNodeElement(nodeElement);
            }
        }
    }

    private void removeUnmappedNodeDefinitionVariables(NodeDefinition nodeDefinition) {
        ArrayList<WPVariable> arrayList = new ArrayList<WPVariable>();
        if (nodeDefinition.getVariables() != null) {
            arrayList.addAll(nodeDefinition.getVariables());
        }
        for (WPVariable wPVariable : arrayList) {
            String string;
            String string2 = string = wPVariable != null ? wPVariable.getName() : null;
            if (string != null && string.trim().length() != 0) continue;
            this.removeUnmappedNodeDefinitionVariable(nodeDefinition, wPVariable);
        }
    }

    private void removeUnmappedNodeDefinitionVariable(NodeDefinition nodeDefinition, WPVariable wPVariable) {
        NodeDefinitionType nodeDefinitionType = nodeDefinition.getNodeType();
        if (nodeDefinitionType == NodeDefinitionType.SingleNode) {
            AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeDefinition.getNode();
            automaticTaskNode.removeVariable(wPVariable.getMappedName());
        } else if (nodeDefinitionType == NodeDefinitionType.SuperState) {
            String string = wPVariable.getMappedName();
            nodeDefinition.removeVariable(string);
            NodeElement[] nodeElementArray = nodeDefinition.getNodeElements();
            if (nodeElementArray == null) {
                return;
            }
            NodeElement[] nodeElementArray2 = nodeElementArray;
            int n = nodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeDefinition nodeDefinition2;
                List<WPVariable> list;
                NodeElement nodeElement = nodeElementArray2[n2];
                if (nodeElement instanceof NodeDefinition && (list = (nodeDefinition2 = (NodeDefinition)nodeElement).getVariables()) != null) {
                    AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeDefinition2.getNode();
                    for (WPVariable wPVariable2 : list) {
                        if (!string.equals(wPVariable2.getName())) continue;
                        automaticTaskNode.removeVariable(wPVariable2.getMappedName());
                    }
                }
                ++n2;
            }
        }
    }

    private void fixSingleNodeNodeDefinition(NodeElementContainer nodeElementContainer, NodeDefinition nodeDefinition) {
        Transition[] transitionArray;
        AbstractNode abstractNode = nodeDefinition.getNode();
        Transition[] transitionArray2 = transitionArray = nodeDefinition.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray2[n2];
            nodeDefinition.removeTransition(transition);
            transition.setSource((NodeElement)abstractNode);
            abstractNode.addTransition(transition);
            ++n2;
        }
    }

    private void fixSuperStateNodeDefinition(WorkflowTemplate workflowTemplate, NodeDefinition nodeDefinition) {
        SuperState superState = (SuperState)nodeDefinition.getNode();
        this.removeNodeDefinitionVariables(nodeDefinition);
        this.removeNodeDefinitions((NodeElementContainer)superState);
        NodeElement nodeElement2 = this.getSuperStateEntryNode(superState);
        String string = "/" + nodeElement2.getName();
        Set<Transition> set = this.getIncomingTransitions(workflowTemplate, nodeDefinition);
        for (Transition nodeElement3 : set) {
            nodeElement3.setTo(String.valueOf(nodeElement3.getTo()) + string);
        }
        NodeElement nodeElement = this.getSuperStateExitNode(superState);
        Set<Transition> set2 = this.getTransitionsToNode(superState, nodeElement);
        WPTransition wPTransition = (WPTransition)nodeDefinition.getTransitions()[0];
        nodeDefinition.removeTransition(wPTransition);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            WPTransition wPTransition2 = (WPTransition)transition;
            wPTransition2.setTo("/" + wPTransition.getTo());
            ActionElement[] actionElementArray = wPTransition.getActionElements();
            int n = actionElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionElement actionElement = actionElementArray[n2];
                if (actionElement instanceof Action) {
                    Action action = this.cloneAction((Action)actionElement, transition.getFactory());
                    this.addRefAction(wPTransition2, action);
                }
                ++n2;
            }
        }
        superState.removeNodeElement(nodeElement);
    }

    /*
     * WARNING - void declaration
     */
    private void removeNodeDefinitionVariables(NodeDefinition nodeDefinition) {
        List<WPVariable> list = nodeDefinition.getVariables();
        NodeElement[] nodeElementArray = nodeDefinition.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray;
            NodeDefinition nodeDefinition2;
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof NodeDefinition) {
                nodeDefinition2 = (NodeDefinition)nodeElement;
                for (WPVariable wPVariable : nodeDefinition2.getVariables()) {
                    objectArray = this.findVariableByMappedName(list, wPVariable.getName());
                    if (nodeDefinition2.getCompositeKey(wPVariable.getMappedName()) != null) {
                        nodeDefinition2.setCompositeKey(wPVariable.getMappedName(), objectArray.getName());
                    }
                    wPVariable.setName(objectArray.getName());
                }
            } else if (nodeElement instanceof Decision) {
                void var8_11;
                nodeDefinition2 = (Decision)nodeElement;
                String string = nodeDefinition2.getExpression();
                if (string != null && string.length() > 0) {
                    Map<Integer, String> map = DecisionExprValidationUtil.getOperands(nodeDefinition2.getExpression());
                    objectArray = map.keySet().toArray();
                    Arrays.sort(objectArray);
                    int n3 = string.length();
                    Object[] objectArray2 = objectArray;
                    int n4 = objectArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object object = objectArray2[n5];
                        int n6 = (Integer)object;
                        String string2 = (String)map.get(n6);
                        WPVariable wPVariable = this.findVariableByMappedName(list, string2);
                        int n7 = n6 - (n3 - var8_11.length());
                        String string3 = String.valueOf(var8_11.substring(0, n7)) + wPVariable.getName() + var8_11.substring(n7 + string2.length());
                        ++n5;
                    }
                }
                nodeDefinition2.setExpression((String)var8_11);
            }
            ++n2;
        }
    }

    private WPVariable findVariableByMappedName(List<WPVariable> list, String string) {
        for (WPVariable wPVariable : list) {
            if (!wPVariable.getMappedName().equals(string)) continue;
            return wPVariable;
        }
        return null;
    }

    private NodeElement getSuperStateEntryNode(SuperState superState) {
        Transition transition;
        NodeElement nodeElement;
        HashSet<String> hashSet = new HashSet<String>();
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            nodeElement = nodeElementArray[n2];
            Transition[] transitionArray = nodeElement.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                transition = transitionArray[n4];
                hashSet.add(transition.getTo());
                ++n4;
            }
            ++n2;
        }
        nodeElement = null;
        transition = superState.getNodeElements();
        int n5 = ((NodeElement[])transition).length;
        n = 0;
        while (n < n5) {
            NodeElement nodeElement2 = transition[n];
            if (!hashSet.contains(nodeElement2.getName())) {
                nodeElement = nodeElement2;
                break;
            }
            ++n;
        }
        return nodeElement;
    }

    private NodeElement getSuperStateExitNode(SuperState superState) {
        NodeElement nodeElement = null;
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement2 = nodeElementArray[n2];
            if (nodeElement2.getTransitions().length == 0) {
                nodeElement = nodeElement2;
                break;
            }
            ++n2;
        }
        return nodeElement;
    }

    private Set<Transition> getTransitionsToNode(SuperState superState, NodeElement nodeElement) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement2 = nodeElementArray[n2];
            Transition[] transitionArray = nodeElement2.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                if (transition.getTo().equals(nodeElement.getName())) {
                    hashSet.add(transition);
                }
                ++n4;
            }
            ++n2;
        }
        return hashSet;
    }

    private Set<Transition> getIncomingTransitions(WorkflowTemplate workflowTemplate, NodeDefinition nodeDefinition) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            this.getIncomingTransitions(nodeElement, nodeDefinition, false, hashSet);
            if (nodeElement instanceof NodeDefinition) {
                NodeDefinition nodeDefinition2 = (NodeDefinition)nodeElement;
                AbstractNode abstractNode = nodeDefinition2.getNode();
                switch (nodeDefinition2.getNodeType()) {
                    case SingleNode: {
                        this.getIncomingTransitions((NodeElement)abstractNode, nodeDefinition, false, hashSet);
                        break;
                    }
                    case SuperState: {
                        SuperState superState = (SuperState)abstractNode;
                        NodeElement[] nodeElementArray2 = superState.getNodeElements();
                        int n3 = nodeElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            NodeElement nodeElement2 = nodeElementArray2[n4];
                            this.getIncomingTransitions(nodeElement2, nodeDefinition, true, hashSet);
                            ++n4;
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    private void getIncomingTransitions(NodeElement nodeElement, NodeDefinition nodeDefinition, boolean bl, Set<Transition> set) {
        Transition[] transitionArray = nodeElement.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray[n2];
            if (this.isIncomingTransition(transition, (NodeElement)nodeDefinition, bl)) {
                set.add(transition);
            }
            ++n2;
        }
    }

    private boolean isIncomingTransition(Transition transition, NodeElement nodeElement, boolean bl) {
        String string = transition.getTo();
        String string2 = nodeElement.getName();
        String string3 = "/" + string2;
        return bl ? string.equals(string3) : string.equals(string2);
    }

    private void addRefAction(WPTransition wPTransition, Action action) {
        if (!wPTransition.hasAction(action.getRefName())) {
            wPTransition.addActionElement((ActionElement)action);
        }
    }

    private Action cloneAction(Action action, SemanticElementFactory semanticElementFactory) {
        Action action2 = this.createAction(semanticElementFactory);
        action2.setAsync(action.getAsync());
        action2.setClassName(action.getClassName());
        action2.setAcceptPropagatedEvents(action.getAcceptPropagatedEvents());
        action2.setConfigInfo(action.getConfigInfo());
        action2.setClassName(action.getClassName());
        action2.setConfigType(action.getConfigType());
        action2.setExpression(action.getExpression());
        action2.setName(action.getName());
        action2.setRefName(action.getRefName());
        return action2;
    }

    private Action createAction(SemanticElementFactory semanticElementFactory) {
        return (Action)semanticElementFactory.createById("org.jbpm.gd.jpdl.action");
    }
}

