/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IMessageUIDGenerator;

public class MessageUIDGenerator
implements IMessageUIDGenerator {
    private static final String MESSAGE_UID_SEPARATOR = ".";
    private static final String NUMERIC_SET = "0123456789";
    private static final String CHARACTER_SET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public String generateMessageUID(Message message, ResourceType resourceType) {
        ApplicationProperties applicationProperties = ApplicationProperties.getInstance();
        String string = applicationProperties.getProperty("WFS.ResourceType.SystemId");
        String string2 = applicationProperties.getProperty("DeploymentKey");
        String string3 = message.isIncoming() ? resourceType.getSystemId() : string;
        String string4 = message.isIncoming() ? string : resourceType.getSystemId();
        String string5 = this.generateMessageID(resourceType.getMessageSequenceNumber());
        String string6 = String.valueOf(string3) + string4 + string5 + MESSAGE_UID_SEPARATOR + string2;
        return string6.trim();
    }

    private String generateMessageID(int n) {
        String string = null;
        int n2 = NUMERIC_SET.length();
        int n3 = CHARACTER_SET.length();
        int n4 = n2 * n2;
        int n5 = n3 * n3;
        int n6 = n2 * n3;
        int n7 = n4 - 1;
        int n8 = n7 + n6;
        int n9 = n8 + n6;
        int n10 = n9 + n5;
        if (n < 0) {
            String string2 = "The Message UID's sequence number must be generated from an integer value >= 0, got value: " + n;
            throw new IllegalArgumentException(string2);
        }
        if (n <= n7) {
            int n11 = n % n2;
            int n12 = n / n2;
            string = String.valueOf(NUMERIC_SET.charAt(n12)) + NUMERIC_SET.charAt(n11);
        } else if (n <= n8) {
            int n13 = (n -= n7 + 1) % n2;
            int n14 = n / n2;
            string = String.valueOf(CHARACTER_SET.charAt(n14)) + NUMERIC_SET.charAt(n13);
        } else if (n <= n9) {
            int n15 = (n -= n8 + 1) % n3;
            int n16 = n / n3;
            string = String.valueOf(NUMERIC_SET.charAt(n16)) + CHARACTER_SET.charAt(n15);
        } else if (n <= n10) {
            int n17 = (n -= n9 + 1) % n3;
            int n18 = n / n3;
            string = String.valueOf(CHARACTER_SET.charAt(n18)) + CHARACTER_SET.charAt(n17);
        } else {
            String string3 = "The Message UID's sequence number must be generated from an integer value < " + n10 + ", got value: " + n;
            throw new IllegalArgumentException(string3);
        }
        return string;
    }
}

